/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.util.Util;

public class AnycastAddress
implements Address {
    protected Collection<Address> destinations = new ArrayList<Address>(5);
    private static final long serialVersionUID = -3133792315497822421L;

    public AnycastAddress() {
    }

    public AnycastAddress(Collection<Address> addresses) {
        this.addAll(addresses);
    }

    public AnycastAddress(Address ... addresses) {
        this.add(addresses);
    }

    public void add(Address ... addresses) {
        if (addresses == null || addresses.length == 0) {
            return;
        }
        for (Address address : addresses) {
            this._add(address);
        }
    }

    protected void _add(Address address) {
        if (!this.destinations.contains(address)) {
            this.destinations.add(address);
        }
    }

    public void addAll(Collection<Address> addresses) {
        if (addresses != null && !addresses.isEmpty()) {
            for (Address address : addresses) {
                this._add(address);
            }
        }
    }

    public Collection<Address> getAddresses() {
        return this.destinations;
    }

    @Override
    public int size() {
        int size = 4;
        for (Address address : this.destinations) {
            size += Util.size(address);
        }
        return size;
    }

    public String toString() {
        return "AnycastAddress " + this.destinations;
    }

    public int hashCode() {
        int hc = 0;
        for (Address address : this.destinations) {
            hc += address.hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnycastAddress)) {
            return false;
        }
        AnycastAddress other = (AnycastAddress)obj;
        return other == this || this.destinations.containsAll(other.destinations) && other.destinations.containsAll(this.destinations);
    }

    @Override
    public int compareTo(Address o) {
        int hc2;
        if (this == o) {
            return 0;
        }
        if (!(o instanceof AnycastAddress)) {
            throw new ClassCastException("comparison between different classes: the other object is " + (o != null ? o.getClass() : o));
        }
        AnycastAddress other = (AnycastAddress)o;
        int hc1 = this.hashCode();
        if (hc1 == (hc2 = other.hashCode())) {
            return this.destinations.size() < other.destinations.size() ? -1 : (this.destinations.size() > other.destinations.size() ? 1 : 0);
        }
        return hc1 < hc2 ? -1 : 1;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        Util.writeAddresses(this.destinations, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.destinations = Util.readAddresses(in, ArrayList.class);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        try {
            this.writeTo(objectOutput);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.readFrom(objectInput);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

