/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.acl.Group;
import java.util.Collection;
import java.util.List;
import javax.jcr.security.AccessControlEntry;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntryFilterImpl
implements EntryFilter {
    private static final Logger log = LoggerFactory.getLogger(EntryFilterImpl.class);
    private final Collection<String> principalNames;

    EntryFilterImpl(Collection<String> principalNames) {
        this.principalNames = principalNames;
    }

    @Override
    public void filterEntries(List<AccessControlEntry> entries, List<AccessControlEntry> ... resultLists) {
        if (resultLists.length == 2) {
            List<AccessControlEntry> userAces = resultLists[0];
            List<AccessControlEntry> groupAces = resultLists[1];
            int uInsertIndex = userAces.size();
            int gInsertIndex = groupAces.size();
            for (AccessControlEntry ace : entries) {
                if (this.principalNames != null && !this.principalNames.contains(ace.getPrincipal().getName())) continue;
                if (ace.getPrincipal() instanceof Group) {
                    groupAces.add(gInsertIndex, ace);
                    continue;
                }
                userAces.add(uInsertIndex, ace);
            }
        } else {
            log.warn("Filtering aborted. Expected 2 result lists.");
        }
    }
}

