/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki;

import java.io.IOException;
import java.util.Locale;
import org.jamwiki.DataAccessException;
import org.jamwiki.DataHandler;
import org.jamwiki.SearchEngine;
import org.jamwiki.WikiException;
import org.jamwiki.model.WikiGroup;
import org.jamwiki.model.WikiUser;
import org.jamwiki.utils.WikiCache;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.WikiUtil;

public class WikiBase {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiBase.class.getName());
    private static WikiBase instance = null;
    private static DataHandler dataHandler = null;
    private static SearchEngine searchEngine = null;
    public static final String CACHE_PARSED_TOPIC_CONTENT = "org.jamwiki.WikiBase.CACHE_PARSED_TOPIC_CONTENT";
    private static WikiGroup GROUP_REGISTERED_USER = null;
    public static final String PERSISTENCE_EXTERNAL = "DATABASE";
    public static final String PERSISTENCE_INTERNAL = "INTERNAL";
    public static final String SPECIAL_PAGE_STARTING_POINTS = "StartingPoints";
    public static final String SPECIAL_PAGE_LEFT_MENU = "LeftMenu";
    public static final String SPECIAL_PAGE_BOTTOM_AREA = "BottomArea";
    public static final String SPECIAL_PAGE_STYLESHEET = "StyleSheet";
    public static final int UPLOAD_ALL = 0;
    public static final int UPLOAD_BLACKLIST = 2;
    public static final int UPLOAD_NONE = 1;
    public static final int UPLOAD_WHITELIST = 3;

    private WikiBase() throws IOException {
        this.reload();
    }

    public static DataHandler getDataHandler() {
        return dataHandler;
    }

    public static WikiGroup getGroupRegisteredUser() {
        if (WikiUtil.isFirstUse() || WikiUtil.isUpgrade()) {
            throw new IllegalStateException("Cannot retrieve group information prior to completing setup/upgrade");
        }
        if (GROUP_REGISTERED_USER == null) {
            try {
                GROUP_REGISTERED_USER = WikiBase.getDataHandler().lookupWikiGroup("GROUP_REGISTERED_USER");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to retrieve registered users group", e);
            }
        }
        return GROUP_REGISTERED_USER;
    }

    public static SearchEngine getSearchEngine() {
        return searchEngine;
    }

    public static void reload() throws IOException {
        dataHandler = WikiUtil.dataHandlerInstance();
        if (searchEngine != null) {
            searchEngine.shutdown();
        }
        searchEngine = WikiUtil.searchEngineInstance();
    }

    public static void reset(Locale locale, WikiUser user, String username, String encryptedPassword) throws DataAccessException, IOException, WikiException {
        instance = new WikiBase();
        WikiCache.initialize();
        dataHandler.setup(locale, user, username, encryptedPassword);
    }

    static {
        try {
            instance = new WikiBase();
        }
        catch (Exception e) {
            logger.error("Failure while initializing WikiBase", e);
        }
    }
}

