/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.internal.dynamic.DynamicTypeInstantiationPolicy;
import org.eclipse.persistence.internal.dynamic.ValuesAccessor;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceWorkbenchXMLProject;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTypeBuilder {
    static XMLParser xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
    protected DynamicTypeImpl entityType;

    public DynamicTypeBuilder(Class<?> dynamicClass, DynamicType parentType, String ... tableNames) {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(dynamicClass);
        this.entityType = new DynamicTypeImpl(descriptor, parentType);
        this.configure(descriptor, tableNames);
    }

    public DynamicTypeBuilder(DynamicClassLoader dcl, ClassDescriptor descriptor, DynamicType parentType) {
        this.entityType = new DynamicTypeImpl(descriptor, parentType);
        if (descriptor.getJavaClass() == null) {
            this.addDynamicClasses(dcl, descriptor.getJavaClassName(), parentType);
        }
        this.configure(descriptor, new String[0]);
    }

    protected void addDynamicClasses(DynamicClassLoader dcl, String className, DynamicType parentType) {
        if (parentType == null) {
            dcl.addClass(className);
        } else if (parentType.getJavaClass() == null) {
            dcl.addClass(className, new DynamicClassWriter(parentType.getClassName()));
        } else {
            dcl.addClass(className, parentType.getJavaClass());
        }
    }

    protected void configure(ClassDescriptor descriptor, String ... tableNames) {
        int index;
        if (tableNames != null) {
            if (tableNames.length == 0) {
                if (descriptor.getTables().size() == 0) {
                    descriptor.descriptorIsAggregate();
                }
            } else {
                for (index = 0; index < tableNames.length; ++index) {
                    descriptor.addTableName(tableNames[index]);
                }
            }
        }
        descriptor.setObjectChangePolicy(new AttributeChangeTrackingPolicy());
        descriptor.setInstantiationPolicy(new DynamicTypeInstantiationPolicy((DynamicTypeImpl)this.getType()));
        for (index = 0; index < descriptor.getMappings().size(); ++index) {
            this.addMapping(descriptor.getMappings().get(index));
        }
        descriptor.setProperty("ENTITY_TYPE", this.entityType);
    }

    public DynamicType getType() {
        return this.entityType;
    }

    private boolean requiresInitialization(DatabaseMapping mapping) {
        if (mapping.isDirectToFieldMapping() && mapping.getAttributeClassification() != null && mapping.getAttributeClassification().isPrimitive()) {
            return true;
        }
        if (mapping.isForeignReferenceMapping()) {
            ForeignReferenceMapping frMapping = (ForeignReferenceMapping)mapping;
            return frMapping.usesIndirection() || frMapping.isCollectionMapping();
        }
        if (mapping.isAggregateMapping() && !mapping.isXMLMapping()) {
            return !((AggregateObjectMapping)mapping).isNullAllowed();
        }
        return false;
    }

    public void setPrimaryKeyFields(String ... pkFieldNames) {
        if (pkFieldNames != null && pkFieldNames.length > 0) {
            for (int index = 0; index < pkFieldNames.length; ++index) {
                DatabaseField pkField = new DatabaseField(pkFieldNames[index]);
                if (this.getType().getDescriptor().getPrimaryKeyFields().contains(pkField)) continue;
                this.getType().getDescriptor().addPrimaryKeyFieldName(pkFieldNames[index]);
            }
        }
    }

    public DirectToFieldMapping addDirectMapping(String name, Class<?> javaType, String fieldName) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setAttributeName(name);
        mapping.setFieldName(fieldName);
        mapping.setAttributeClassification(javaType);
        return (DirectToFieldMapping)this.addMapping(mapping);
    }

    public OneToOneMapping addOneToOneMapping(String name, DynamicType refType, String ... fkFieldNames) {
        if (fkFieldNames == null || refType.getDescriptor().getPrimaryKeyFields().size() != fkFieldNames.length) {
            throw new IllegalArgumentException("Invalid FK field names: " + fkFieldNames + " for target: " + refType);
        }
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceClass(refType.getJavaClass());
        for (int index = 0; index < fkFieldNames.length; ++index) {
            String targetField = refType.getDescriptor().getPrimaryKeyFields().get(index).getName();
            mapping.addForeignKeyFieldName(fkFieldNames[index], targetField);
        }
        return (OneToOneMapping)this.addMapping(mapping);
    }

    public OneToManyMapping addOneToManyMapping(String name, DynamicType refType, String ... fkFieldNames) {
        if (fkFieldNames == null || this.getType().getDescriptor().getPrimaryKeyFields().size() != fkFieldNames.length) {
            throw new IllegalArgumentException("Invalid FK field names: " + fkFieldNames + " for target: " + refType);
        }
        OneToManyMapping mapping = new OneToManyMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceClass(refType.getJavaClass());
        for (int index = 0; index < fkFieldNames.length; ++index) {
            String targetField = this.getType().getDescriptor().getPrimaryKeyFields().get(index).getName();
            mapping.addTargetForeignKeyFieldName(fkFieldNames[index], targetField);
        }
        mapping.useTransparentList();
        return (OneToManyMapping)this.addMapping(mapping);
    }

    public DirectCollectionMapping addDirectCollectionMapping(String name, String targetTable, String valueColumn, Class<?> valueType, String ... fkFieldNames) throws IllegalArgumentException {
        if (fkFieldNames == null || this.getType().getDescriptor().getPrimaryKeyFields().size() != fkFieldNames.length) {
            throw new IllegalArgumentException("Invalid FK field names: " + fkFieldNames + " for target: ");
        }
        DirectCollectionMapping mapping = new DirectCollectionMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceTableName(targetTable);
        mapping.setDirectFieldName(valueColumn);
        mapping.setDirectFieldClassification(valueType);
        for (int index = 0; index < fkFieldNames.length; ++index) {
            String targetField = this.getType().getDescriptor().getPrimaryKeyFields().get(index).getName();
            mapping.addReferenceKeyFieldName(fkFieldNames[index], targetField);
        }
        mapping.useTransparentList();
        return (DirectCollectionMapping)this.addMapping(mapping);
    }

    public AggregateObjectMapping addAggregateObjectMapping(String name, DynamicType refType, boolean allowsNull) {
        AggregateObjectMapping mapping = new AggregateObjectMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceClass(refType.getJavaClass());
        mapping.setIsNullAllowed(allowsNull);
        return (AggregateObjectMapping)this.addMapping(mapping);
    }

    public void addManyToManyMapping(String name, DynamicType refType, String relationshipTableName) {
        ManyToManyMapping mapping = new ManyToManyMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceClass(refType.getJavaClass());
        mapping.setRelationTableName(relationshipTableName);
        for (DatabaseField sourcePK : this.getType().getDescriptor().getPrimaryKeyFields()) {
            mapping.addSourceRelationKeyFieldName(sourcePK.getName(), sourcePK.getQualifiedName());
        }
        for (DatabaseField targetPK : refType.getDescriptor().getPrimaryKeyFields()) {
            String relField = targetPK.getName();
            if (mapping.getSourceRelationKeyFieldNames().contains(relField)) {
                relField = refType.getName() + "_" + relField;
            }
            mapping.addTargetRelationKeyFieldName(relField, targetPK.getQualifiedName());
        }
        mapping.useTransparentList();
        this.addMapping(mapping);
    }

    protected DatabaseMapping addMapping(DatabaseMapping mapping) {
        String typeName;
        ClassDescriptor descriptor = this.getType().getDescriptor();
        if (!descriptor.getMappings().contains(mapping)) {
            descriptor.addMapping(mapping);
        }
        int index = descriptor.getMappings().indexOf(mapping);
        if (this.getType().getParentType() != null) {
            DynamicType current = this.getType();
            while (current.getParentType() != null) {
                index += current.getParentType().getDescriptor().getMappings().size();
                current = current.getParentType();
            }
        }
        if (mapping.getAttributeClassification() == null && mapping.isAbstractDirectMapping() && (typeName = ((AbstractDirectMapping)mapping).getAttributeClassificationName()) != null) {
            typeName = typeName.trim();
            Class attrType = ConversionManager.getDefaultManager().convertClassNameToClass(typeName);
            ((AbstractDirectMapping)mapping).setAttributeClassification(attrType);
        }
        mapping.setAttributeAccessor(new ValuesAccessor(this.getType(), mapping, index));
        if (this.requiresInitialization(mapping)) {
            this.entityType.getMappingsRequiringInitialization().add(mapping);
        }
        return mapping;
    }

    public void configureSequencing(String numberName, String numberFieldName) {
        this.getType().getDescriptor().setSequenceNumberName(numberName);
        this.getType().getDescriptor().setSequenceNumberFieldName(numberFieldName);
    }

    public void configureSequencing(Sequence sequence, String numberName, String numberFieldName) {
        this.configureSequencing(numberName, numberFieldName);
        this.getType().getDescriptor().setSequence(sequence);
    }

    public static Project loadDynamicProject(String resourcePath, DatabaseLogin login, DynamicClassLoader dynamicClassLoader) throws IOException {
        if (resourcePath == null) {
            throw new NullPointerException("null resourceStream");
        }
        if (dynamicClassLoader == null) {
            throw new NullPointerException("null dynamicClassLoader");
        }
        return DynamicTypeBuilder.loadDynamicProject(dynamicClassLoader.getResourceAsStream(resourcePath), login, dynamicClassLoader);
    }

    public static Project loadDynamicProject(InputStream resourceStream, DatabaseLogin login, DynamicClassLoader dynamicClassLoader) throws IOException {
        if (resourceStream == null) {
            throw new NullPointerException("null resourceStream");
        }
        if (dynamicClassLoader == null) {
            throw new NullPointerException("null dynamicClassLoader");
        }
        ObjectPersistenceWorkbenchXMLProject opmProject = new ObjectPersistenceWorkbenchXMLProject();
        Document document = xmlParser.parse(resourceStream);
        Project project = XMLProjectReader.readObjectPersistenceRuntimeFormat(document, dynamicClassLoader, opmProject);
        return DynamicTypeBuilder.loadDynamicProject(project, login, dynamicClassLoader);
    }

    public static Project loadDynamicProject(Project project, DatabaseLogin login, DynamicClassLoader dynamicClassLoader) {
        if (project != null) {
            if (login == null) {
                if (project.getLogin() == null) {
                    project.setLogin(new DatabaseLogin());
                }
            } else {
                project.setLogin(login);
            }
            if (project.getLogin().getPlatform() == null) {
                project.getLogin().setPlatform(new DatabasePlatform());
            }
            project.getLogin().getPlatform().getConversionManager().setLoader(dynamicClassLoader);
            for (ClassDescriptor descriptor : project.getAliasDescriptors().values()) {
                if (descriptor.getJavaClass() != null) continue;
                DynamicTypeBuilder.createType(dynamicClassLoader, descriptor, project);
            }
            project.convertClassNamesToClasses(dynamicClassLoader);
        }
        return project;
    }

    private static DynamicType createType(DynamicClassLoader dcl, ClassDescriptor descriptor, Project project) {
        DynamicType type;
        Class<?> javaClass = null;
        try {
            javaClass = dcl.loadClass(descriptor.getJavaClassName());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (javaClass != null) {
            descriptor.setJavaClass(javaClass);
        }
        DynamicType parent = null;
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().getParentClassName() != null) {
            ClassDescriptor parentDesc = null;
            Iterator i = project.getOrderedDescriptors().iterator();
            while (parentDesc == null && i.hasNext()) {
                ClassDescriptor d = (ClassDescriptor)i.next();
                if (!d.getJavaClassName().equals(descriptor.getInheritancePolicy().getParentClassName())) continue;
                parentDesc = d;
            }
            if (parentDesc == null) {
                throw ValidationException.missingDescriptor(descriptor.getInheritancePolicy().getParentClassName());
            }
            parent = DynamicHelper.getType(parentDesc);
            if (parent == null) {
                parent = DynamicTypeBuilder.createType(dcl, parentDesc, project);
            }
        }
        if ((type = DynamicHelper.getType(descriptor)) == null) {
            type = new DynamicTypeBuilder(dcl, descriptor, parent).getType();
        }
        return type;
    }
}

