/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TemplateResourceLoaderUtil {
    private static Map<String, TemplateResourceLoader> _templateResourceLoaders = new ConcurrentHashMap<String, TemplateResourceLoader>();

    public static void clearCache() {
        for (TemplateResourceLoader templateResourceLoader : _templateResourceLoaders.values()) {
            templateResourceLoader.clearCache();
        }
    }

    public static void clearCache(String templateResourceLoaderName) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = TemplateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
        templateResourceLoader.clearCache();
    }

    public static void clearCache(String templateResourceLoaderName, String templateId) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = TemplateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
        templateResourceLoader.clearCache(templateId);
    }

    public static void destroy() {
        for (TemplateResourceLoader templateResourceLoader : _templateResourceLoaders.values()) {
            templateResourceLoader.destroy();
        }
        _templateResourceLoaders.clear();
    }

    public static TemplateResource getTemplateResource(String templateResourceLoaderName, String templateId) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = TemplateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
        return templateResourceLoader.getTemplateResource(templateId);
    }

    public static TemplateResourceLoader getTemplateResourceLoader(String templateResourceLoaderName) {
        return _templateResourceLoaders.get(templateResourceLoaderName);
    }

    public static Set<String> getTemplateResourceLoaderNames() {
        return _templateResourceLoaders.keySet();
    }

    public static Map<String, TemplateResourceLoader> getTemplateResourceLoaders() {
        return Collections.unmodifiableMap(_templateResourceLoaders);
    }

    public static boolean hasTemplateResource(String templateResourceLoaderName, String templateId) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = TemplateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
        return templateResourceLoader.hasTemplateResource(templateId);
    }

    public static boolean hasTemplateResourceLoader(String templateResourceLoaderName) {
        return _templateResourceLoaders.containsKey(templateResourceLoaderName);
    }

    public static void registerTemplateResourceLoader(TemplateResourceLoader templateResourceLoader) {
        _templateResourceLoaders.put(templateResourceLoader.getName(), templateResourceLoader);
    }

    public static void unregisterTemplateResourceLoader(String templateResourceLoaderName) {
        TemplateResourceLoader templateResourceLoader = _templateResourceLoaders.remove(templateResourceLoaderName);
        if (templateResourceLoader != null) {
            templateResourceLoader.destroy();
        }
    }

    public void setTemplateResourceLoaders(List<TemplateResourceLoader> templateResourceLoaders) {
        for (TemplateResourceLoader templateResourceLoader : templateResourceLoaders) {
            _templateResourceLoaders.put(templateResourceLoader.getName(), templateResourceLoader);
        }
    }

    private static TemplateResourceLoader _getTemplateResourceLoader(String templateResourceLoaderName) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = _templateResourceLoaders.get(templateResourceLoaderName);
        if (templateResourceLoader == null) {
            throw new TemplateException("Unsupported template resource loader " + templateResourceLoaderName);
        }
        return templateResourceLoader;
    }
}

