/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.encoding.ContentTypeImpl;
import com.sun.xml.ws.encoding.StreamSOAPCodec;
import com.sun.xml.ws.message.stream.StreamHeader;
import com.sun.xml.ws.message.stream.StreamHeader12;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StreamSOAP12Codec
extends StreamSOAPCodec {
    public static final String SOAP12_MIME_TYPE = "application/soap+xml";
    public static final String SOAP12_CONTENT_TYPE = "application/soap+xml;charset=\"utf-8\"";
    private static final List<String> expectedContentTypes = Collections.singletonList("application/soap+xml");
    public static final ContentTypeImpl defaultContentType = new ContentTypeImpl("application/soap+xml;charset=\"utf-8\"");

    StreamSOAP12Codec() {
        super(SOAPVersion.SOAP_12);
    }

    @Override
    public String getMimeType() {
        return SOAP12_MIME_TYPE;
    }

    @Override
    protected final StreamHeader createHeader(XMLStreamReader reader, XMLStreamBuffer mark) {
        return new StreamHeader12(reader, mark);
    }

    @Override
    protected ContentType getContentType(String soapAction) {
        if (soapAction == null) {
            return defaultContentType;
        }
        return new ContentTypeImpl("application/soap+xml;charset=\"utf-8\";action=\"" + soapAction + "\"");
    }

    @Override
    protected List<String> getExpectedContentTypes() {
        return expectedContentTypes;
    }
}

