/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.LFO;
import org.apache.poi.hwpf.model.LFOData;
import org.apache.poi.hwpf.model.LSTF;
import org.apache.poi.hwpf.model.ListData;
import org.apache.poi.hwpf.model.ListLevel;
import org.apache.poi.hwpf.model.PlfLfo;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
public final class ListTables {
    private static POILogger log = POILogFactory.getLogger(ListTables.class);
    private final LinkedHashMap<Integer, ListData> _listMap = new LinkedHashMap();
    private PlfLfo _plfLfo;

    public ListTables() {
    }

    public ListTables(byte[] tableStream, int lstOffset, int fcPlfLfo, int lcbPlfLfo) {
        int offset = lstOffset;
        int cLst = LittleEndian.getShort((byte[])tableStream, (int)offset);
        int levelOffset = (offset += 2) + cLst * LSTF.getSize();
        for (int x = 0; x < cLst; ++x) {
            ListData lst = new ListData(tableStream, offset);
            this._listMap.put(lst.getLsid(), lst);
            offset += LSTF.getSize();
            int num = lst.numLevels();
            for (int y = 0; y < num; ++y) {
                ListLevel lvl = new ListLevel();
                levelOffset += lvl.read(tableStream, levelOffset);
                lst.setLevel(y, lvl);
            }
        }
        this._plfLfo = new PlfLfo(tableStream, fcPlfLfo, lcbPlfLfo);
    }

    public void writeListDataTo(FileInformationBlock fib, HWPFOutputStream tableStream) throws IOException {
        int startOffset = tableStream.getOffset();
        fib.setFcPlfLst(startOffset);
        int listSize = this._listMap.size();
        ByteArrayOutputStream levelBuf = new ByteArrayOutputStream();
        byte[] shortHolder = new byte[2];
        LittleEndian.putShort((byte[])shortHolder, (short)((short)listSize));
        tableStream.write(shortHolder);
        for (Integer x : this._listMap.keySet()) {
            ListData lst = this._listMap.get(x);
            tableStream.write(lst.toByteArray());
            ListLevel[] lvls = lst.getLevels();
            for (int y = 0; y < lvls.length; ++y) {
                levelBuf.write(lvls[y].toByteArray());
            }
        }
        fib.setLcbPlfLst(tableStream.getOffset() - startOffset);
        tableStream.write(levelBuf.toByteArray());
    }

    public void writeListOverridesTo(FileInformationBlock fib, HWPFOutputStream tableStream) throws IOException {
        this._plfLfo.writeTo(fib, tableStream);
    }

    public LFO getLfo(int ilfo) throws NoSuchElementException {
        return this._plfLfo.getLfo(ilfo);
    }

    public LFOData getLfoData(int ilfo) throws NoSuchElementException {
        return this._plfLfo.getLfoData(ilfo);
    }

    public int getOverrideIndexFromListID(int lsid) throws NoSuchElementException {
        return this._plfLfo.getIlfoByLsid(lsid);
    }

    public ListLevel getLevel(int lsid, int level) {
        ListData lst = this._listMap.get(lsid);
        if (level < lst.numLevels()) {
            ListLevel lvl = lst.getLevels()[level];
            return lvl;
        }
        log.log(5, (Object)("Requested level " + level + " which was greater than the maximum defined (" + lst.numLevels() + ")"));
        return null;
    }

    public ListData getListData(int lsid) {
        return this._listMap.get(lsid);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._listMap == null ? 0 : this._listMap.hashCode());
        result = 31 * result + (this._plfLfo == null ? 0 : this._plfLfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListTables other = (ListTables)obj;
        if (this._listMap == null ? other._listMap != null : !this._listMap.equals(other._listMap)) {
            return false;
        }
        return !(this._plfLfo == null ? other._plfLfo != null : !this._plfLfo.equals(other._plfLfo));
    }

    public int addList(ListData lst, LFO lfo, LFOData lfoData) {
        int lsid = lst.getLsid();
        while (this._listMap.get(lsid) != null) {
            lsid = lst.resetListID();
            lfo.setLsid(lsid);
        }
        this._listMap.put(lsid, lst);
        if (lfo == null && lfoData != null) {
            throw new IllegalArgumentException("LFO and LFOData should be specified both or noone");
        }
        if (lfo != null) {
            this._plfLfo.add(lfo, lfoData);
        }
        return lsid;
    }
}

