/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.search.facet.BaseFacet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.facet.util.FacetValueValidator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class MultiValueFacet
extends BaseFacet {
    private static Log _log = LogFactoryUtil.getLog(MultiValueFacet.class);

    public MultiValueFacet(SearchContext searchContext) {
        super(searchContext);
    }

    public void setValues(boolean[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        boolean[] blArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            boolean value = blArray[n2];
            valuesJSONArray.put(value);
            ++n2;
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(double[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            valuesJSONArray.put(value);
            ++n2;
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(int[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            valuesJSONArray.put(value);
            ++n2;
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(JSONArray values) {
        this.doSetValues(values);
    }

    public void setValues(JSONObject[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        JSONObject[] jSONObjectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            JSONObject value = jSONObjectArray[n2];
            valuesJSONArray.put(value);
            ++n2;
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(long[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            valuesJSONArray.put(value);
            ++n2;
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(String[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            valuesJSONArray.put(value);
            ++n2;
        }
        this.doSetValues(valuesJSONArray);
    }

    @Override
    protected BooleanClause doGetFacetClause() {
        SearchContext searchContext = this.getSearchContext();
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        Object[] values = null;
        if (this.isStatic() && dataJSONObject.has("values")) {
            JSONArray valuesJSONArray = dataJSONObject.getJSONArray("values");
            values = new String[valuesJSONArray.length()];
            int i = 0;
            while (i < valuesJSONArray.length()) {
                values[i] = valuesJSONArray.getString(i);
                ++i;
            }
        }
        String[] valuesParam = StringUtil.split(GetterUtil.getString(searchContext.getAttribute(this.getFieldId())));
        if (!this.isStatic() && valuesParam != null && valuesParam.length > 0) {
            values = valuesParam;
        }
        if (ArrayUtil.isEmpty(values)) {
            return null;
        }
        BooleanQuery facetQuery = BooleanQueryFactoryUtil.create(searchContext);
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            FacetValueValidator facetValueValidator = this.getFacetValueValidator();
            if (searchContext.getUserId() <= 0L || facetValueValidator.check(searchContext, (String)value)) {
                TermQuery termQuery = TermQueryFactoryUtil.create(searchContext, this.getFieldName(), (String)value);
                try {
                    facetQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                }
                catch (ParseException pe) {
                    _log.error(pe, pe);
                }
            }
            ++n2;
        }
        if (!facetQuery.hasClauses()) {
            return null;
        }
        return BooleanClauseFactoryUtil.create(searchContext, facetQuery, BooleanClauseOccur.MUST.getName());
    }

    protected void doSetValues(JSONArray valuesJSONArray) {
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        dataJSONObject.put("values", valuesJSONArray);
    }
}

