/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.extension;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;

public class SDOUtil {
    private static final String HEXADECIMAL_DIGITS = "0123456789abcdefABCDEF";
    private static final String INVALID_URI_WARNING = "SDOUtil: The URI [{0}] used for java package name generation is invalid - generating [{1}].";
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private static boolean asWordSeparator = false;

    private static void preProcessJavaReservedNames(String name) {
        SDOUtil.preProcessReservedNames(name, SDOConstants.javaReservedWordsList, "sdo_type_generation_warning_class_name_violates_java_spec");
    }

    private static void preProcessSDOReservedNames(String name) {
        SDOUtil.preProcessReservedNames(name, SDOConstants.sdoInterfaceReservedWordsList, "sdo_type_generation_warning_class_name_violates_sdo_spec");
    }

    private static void preProcessReservedNames(String name, String[] wordArray, String warningLogKey) {
        for (int i = 0; i < wordArray.length; ++i) {
            if (!wordArray[i].equalsIgnoreCase(name)) continue;
            AbstractSessionLog.getLog().log(6, warningLogKey, new Object[]{"SDOUtil", name, wordArray[i]});
        }
    }

    public static String getDefaultPackageName() {
        return SDOUtil.getPackageNameFromURI("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPackageNameFromURI(String uriString) {
        String strToken2;
        ArrayList<String> strings2;
        StringTokenizer aTokenizer2;
        int position = 0;
        StringBuffer pkgName = new StringBuffer();
        if (null == uriString || uriString.equals("")) {
            AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{uriString, "defaultPackage"}, false);
            return "defaultPackage";
        }
        String originalUriString = uriString;
        boolean invalidOriginalFormat = false;
        boolean invalidScheme = false;
        try {
            int length2;
            String extension2;
            block59: {
                try {
                    URI uri = new URI(uriString);
                    String schemePrefix = uri.getScheme();
                    if (null == schemePrefix) break block59;
                    if (schemePrefix.equalsIgnoreCase("http") || schemePrefix.equalsIgnoreCase("urn")) {
                        uriString = uri.getSchemeSpecificPart();
                    } else {
                        invalidScheme = true;
                    }
                }
                catch (NullPointerException npe) {
                    String strToken2;
                    StringTokenizer aTokenizer2;
                    int length2;
                    String extension2;
                    AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{"null", "defaultPackage"}, false);
                    String string = "defaultPackage";
                    Object var13_9 = null;
                    int potentialPathSepIndex = uriString.lastIndexOf(47);
                    int potentialHostSepIndex = uriString.indexOf(47);
                    int potentialFileExtIndex = uriString.lastIndexOf(46);
                    if ((invalidScheme && potentialFileExtIndex != -1 || potentialFileExtIndex != -1 && potentialPathSepIndex != -1 && potentialHostSepIndex != -1 && potentialPathSepIndex - potentialHostSepIndex > 1) && ((extension2 = uriString.substring(potentialFileExtIndex)).length() == 3 || extension2.length() == 4 || extension2.equalsIgnoreCase(".html"))) {
                        uriString = uriString.substring(0, potentialFileExtIndex);
                    }
                    if ((length2 = (aTokenizer2 = new StringTokenizer(uriString, "/:")).countTokens()) == 0) {
                        return "defaultPackage";
                    }
                    ArrayList<String> strings2 = new ArrayList<String>(length2);
                    while (aTokenizer2.hasMoreTokens()) {
                        strToken2 = aTokenizer2.nextToken();
                        strings2.add(SDOUtil.decodeUriHexadecimalEscapeSequence(strToken2));
                    }
                    strToken2 = ((String)strings2.remove(0)).toLowerCase();
                    aTokenizer2 = new StringTokenizer(strToken2, ".");
                    if (aTokenizer2.countTokens() < 1) {
                        AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{uriString, "defaultPackage"}, false);
                        return "defaultPackage";
                    }
                    while (aTokenizer2.hasMoreTokens()) {
                        strToken2 = aTokenizer2.nextToken();
                        if (strToken2.equals("www")) continue;
                        strings2.add(0, strToken2);
                    }
                    position = 0;
                    for (String aString : strings2) {
                        strings2.set(position++, aString.toLowerCase());
                    }
                    position = 0;
                    Iterator i$ = strings2.iterator();
                    while (true) {
                        String aString;
                        if (!i$.hasNext()) {
                            if (!invalidOriginalFormat) return string;
                            AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{originalUriString, pkgName}, false);
                            return string;
                        }
                        aString = (String)i$.next();
                        StringBuffer buffer = new StringBuffer();
                        for (int j = 0; j < aString.length(); ++j) {
                            char charToken = aString.charAt(j);
                            if (Character.isJavaIdentifierPart(charToken)) {
                                buffer.append(charToken);
                                continue;
                            }
                            buffer.append('_');
                        }
                        if (!Character.isJavaIdentifierStart(buffer.charAt(0))) {
                            buffer.insert(0, '_');
                        }
                        if (position++ != 0) {
                            buffer.insert(0, '.');
                        }
                        pkgName.append(buffer.toString());
                    }
                }
                catch (URISyntaxException use) {
                    String strToken2;
                    StringTokenizer aTokenizer2;
                    int length2;
                    String extension2;
                    invalidOriginalFormat = true;
                    if (uriString.length() > 4) {
                        String prefix = uriString.substring(0, 4);
                        if (prefix.equalsIgnoreCase("urn:")) {
                            uriString = uriString.substring(4);
                        } else {
                            prefix = uriString.substring(0, 5);
                            if (prefix.equalsIgnoreCase("http:")) {
                                uriString = uriString.substring(5);
                            }
                        }
                    }
                    Object var13_10 = null;
                    int potentialPathSepIndex = uriString.lastIndexOf(47);
                    int potentialHostSepIndex = uriString.indexOf(47);
                    int potentialFileExtIndex = uriString.lastIndexOf(46);
                    if ((invalidScheme && potentialFileExtIndex != -1 || potentialFileExtIndex != -1 && potentialPathSepIndex != -1 && potentialHostSepIndex != -1 && potentialPathSepIndex - potentialHostSepIndex > 1) && ((extension2 = uriString.substring(potentialFileExtIndex)).length() == 3 || extension2.length() == 4 || extension2.equalsIgnoreCase(".html"))) {
                        uriString = uriString.substring(0, potentialFileExtIndex);
                    }
                    if ((length2 = (aTokenizer2 = new StringTokenizer(uriString, "/:")).countTokens()) == 0) {
                        return "defaultPackage";
                    }
                    ArrayList<String> strings2 = new ArrayList<String>(length2);
                    while (aTokenizer2.hasMoreTokens()) {
                        strToken2 = aTokenizer2.nextToken();
                        strings2.add(SDOUtil.decodeUriHexadecimalEscapeSequence(strToken2));
                    }
                    strToken2 = ((String)strings2.remove(0)).toLowerCase();
                    aTokenizer2 = new StringTokenizer(strToken2, ".");
                    if (aTokenizer2.countTokens() < 1) {
                        AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{uriString, "defaultPackage"}, false);
                        return "defaultPackage";
                    }
                    while (aTokenizer2.hasMoreTokens()) {
                        strToken2 = aTokenizer2.nextToken();
                        if (strToken2.equals("www")) continue;
                        strings2.add(0, strToken2);
                    }
                    position = 0;
                    for (String aString : strings2) {
                        strings2.set(position++, aString.toLowerCase());
                    }
                    position = 0;
                    Iterator i$ = strings2.iterator();
                    while (true) {
                        String aString;
                        if (!i$.hasNext()) {
                            if (!invalidOriginalFormat) return pkgName.toString();
                            AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{originalUriString, pkgName}, false);
                            return pkgName.toString();
                        }
                        aString = (String)i$.next();
                        StringBuffer buffer = new StringBuffer();
                        for (int j = 0; j < aString.length(); ++j) {
                            char charToken = aString.charAt(j);
                            if (Character.isJavaIdentifierPart(charToken)) {
                                buffer.append(charToken);
                                continue;
                            }
                            buffer.append('_');
                        }
                        if (!Character.isJavaIdentifierStart(buffer.charAt(0))) {
                            buffer.insert(0, '_');
                        }
                        if (position++ != 0) {
                            buffer.insert(0, '.');
                        }
                        pkgName.append(buffer.toString());
                    }
                }
            }
            Object var13_8 = null;
            int potentialPathSepIndex = uriString.lastIndexOf(47);
            int potentialHostSepIndex = uriString.indexOf(47);
            int potentialFileExtIndex = uriString.lastIndexOf(46);
            if ((invalidScheme && potentialFileExtIndex != -1 || potentialFileExtIndex != -1 && potentialPathSepIndex != -1 && potentialHostSepIndex != -1 && potentialPathSepIndex - potentialHostSepIndex > 1) && ((extension2 = uriString.substring(potentialFileExtIndex)).length() == 3 || extension2.length() == 4 || extension2.equalsIgnoreCase(".html"))) {
                uriString = uriString.substring(0, potentialFileExtIndex);
            }
            if ((length2 = (aTokenizer2 = new StringTokenizer(uriString, "/:")).countTokens()) == 0) {
                return "defaultPackage";
            }
            strings2 = new ArrayList<String>(length2);
        }
        catch (Throwable throwable) {
            String strToken2;
            StringTokenizer aTokenizer2;
            int length2;
            String extension2;
            Object var13_11 = null;
            int potentialPathSepIndex = uriString.lastIndexOf(47);
            int potentialHostSepIndex = uriString.indexOf(47);
            int potentialFileExtIndex = uriString.lastIndexOf(46);
            if ((invalidScheme && potentialFileExtIndex != -1 || potentialFileExtIndex != -1 && potentialPathSepIndex != -1 && potentialHostSepIndex != -1 && potentialPathSepIndex - potentialHostSepIndex > 1) && ((extension2 = uriString.substring(potentialFileExtIndex)).length() == 3 || extension2.length() == 4 || extension2.equalsIgnoreCase(".html"))) {
                uriString = uriString.substring(0, potentialFileExtIndex);
            }
            if ((length2 = (aTokenizer2 = new StringTokenizer(uriString, "/:")).countTokens()) == 0) {
                return "defaultPackage";
            }
            ArrayList<String> strings2 = new ArrayList<String>(length2);
            while (aTokenizer2.hasMoreTokens()) {
                strToken2 = aTokenizer2.nextToken();
                strings2.add(SDOUtil.decodeUriHexadecimalEscapeSequence(strToken2));
            }
            strToken2 = ((String)strings2.remove(0)).toLowerCase();
            aTokenizer2 = new StringTokenizer(strToken2, ".");
            if (aTokenizer2.countTokens() < 1) {
                AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{uriString, "defaultPackage"}, false);
                return "defaultPackage";
            }
            while (aTokenizer2.hasMoreTokens()) {
                strToken2 = aTokenizer2.nextToken();
                if (strToken2.equals("www")) continue;
                strings2.add(0, strToken2);
            }
            position = 0;
            for (String aString : strings2) {
                strings2.set(position++, aString.toLowerCase());
            }
            position = 0;
            Iterator i$ = strings2.iterator();
            while (true) {
                String aString;
                if (!i$.hasNext()) {
                    if (!invalidOriginalFormat) throw throwable;
                    AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{originalUriString, pkgName}, false);
                    throw throwable;
                }
                aString = (String)i$.next();
                StringBuffer buffer = new StringBuffer();
                for (int j = 0; j < aString.length(); ++j) {
                    char charToken = aString.charAt(j);
                    if (Character.isJavaIdentifierPart(charToken)) {
                        buffer.append(charToken);
                        continue;
                    }
                    buffer.append('_');
                }
                if (!Character.isJavaIdentifierStart(buffer.charAt(0))) {
                    buffer.insert(0, '_');
                }
                if (position++ != 0) {
                    buffer.insert(0, '.');
                }
                pkgName.append(buffer.toString());
            }
        }
        while (aTokenizer2.hasMoreTokens()) {
            strToken2 = aTokenizer2.nextToken();
            strings2.add(SDOUtil.decodeUriHexadecimalEscapeSequence(strToken2));
        }
        strToken2 = ((String)strings2.remove(0)).toLowerCase();
        aTokenizer2 = new StringTokenizer(strToken2, ".");
        if (aTokenizer2.countTokens() < 1) {
            AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{uriString, "defaultPackage"}, false);
            return "defaultPackage";
        }
        while (aTokenizer2.hasMoreTokens()) {
            strToken2 = aTokenizer2.nextToken();
            if (strToken2.equals("www")) continue;
            strings2.add(0, strToken2);
        }
        position = 0;
        for (String aString : strings2) {
            strings2.set(position++, aString.toLowerCase());
        }
        position = 0;
        for (String aString : strings2) {
            StringBuffer buffer = new StringBuffer();
            for (int j = 0; j < aString.length(); ++j) {
                char charToken = aString.charAt(j);
                if (Character.isJavaIdentifierPart(charToken)) {
                    buffer.append(charToken);
                    continue;
                }
                buffer.append('_');
            }
            if (!Character.isJavaIdentifierStart(buffer.charAt(0))) {
                buffer.insert(0, '_');
            }
            if (position++ != 0) {
                buffer.insert(0, '.');
            }
            pkgName.append(buffer.toString());
        }
        if (!invalidOriginalFormat) return pkgName.toString();
        AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{originalUriString, pkgName}, false);
        return pkgName.toString();
    }

    private static String decodeUriHexadecimalEscapeSequence(String uri) {
        StringBuffer sb = new StringBuffer(uri.length());
        for (int index = 0; index < uri.length(); ++index) {
            char c = uri.charAt(index);
            if (c == '%') {
                if (index + 2 < uri.length() && HEXADECIMAL_DIGITS.indexOf(uri.charAt(index + 1)) >= 0 && HEXADECIMAL_DIGITS.indexOf(uri.charAt(index + 2)) >= 0) {
                    String g = uri.substring(index + 1, index + 3);
                    sb.append((char)Integer.parseInt(g, 16));
                    index += 2;
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String className(String s, boolean isClass) {
        return SDOUtil.className(s, true, isClass, true);
    }

    public static String className(String s, boolean flag, boolean isClass, boolean logOn) {
        SDOUtil.preProcessJavaReservedNames(s);
        SDOUtil.preProcessSDOReservedNames(s);
        String[] as = SDOUtil.getWordList(s);
        StringBuffer stringbuffer = new StringBuffer();
        StringBuffer stringbuffer1 = new StringBuffer();
        if (as.length == 0) {
            return stringbuffer.toString();
        }
        for (int i = 0; i < as.length; ++i) {
            char[] ac = as[i].toCharArray();
            if (Character.isLowerCase(ac[0])) {
                ac[0] = Character.toUpperCase(ac[0]);
            }
            for (int j = 0; j < ac.length; ++j) {
                if (ac[j] >= ' ' && ac[j] < '\u007f') {
                    if (ac[j] == '_' && asWordSeparator) continue;
                    stringbuffer.append(ac[j]);
                    continue;
                }
                if (flag) {
                    stringbuffer.append(SDOUtil.escapeUnicode(stringbuffer1, ac[j]));
                    continue;
                }
                stringbuffer.append(ac[j]);
            }
        }
        String normalizedName = stringbuffer.toString();
        if (!s.equals(normalizedName) && logOn) {
            int logLevel = !s.equalsIgnoreCase(normalizedName) ? 5 : 2;
            if (isClass) {
                AbstractSessionLog.getLog().log(logLevel, "sdo_type_generation_modified_class_naming_format_to", new Object[]{"SDOUtil", s, normalizedName});
            } else {
                AbstractSessionLog.getLog().log(logLevel, "sdo_type_generation_modified_function_naming_format_to", new Object[]{"SDOUtil", s, normalizedName});
            }
        }
        return normalizedName;
    }

    public static String methodName(String s) {
        return SDOUtil.methodName(s, true);
    }

    public static String methodName(String s, boolean flag) {
        return SDOUtil.className(s, flag, false, true);
    }

    public static String setMethodName(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append(SET).append(SDOUtil.methodName(s));
        return stringbuffer.toString();
    }

    public static String getMethodName(String s, String returnType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (returnType.equals(ClassConstants.PBOOLEAN.getName()) || returnType.equals(ClassConstants.BOOLEAN.getName())) {
            stringBuffer.append(IS);
        } else {
            stringBuffer.append(GET);
        }
        stringBuffer.append(SDOUtil.className(s, true, false, false));
        return stringBuffer.toString();
    }

    public static String getBooleanGetMethodName(String s, String returnType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GET);
        stringBuffer.append(SDOUtil.className(s, true, false, false));
        return stringBuffer.toString();
    }

    public static String constantName(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        String[] as = SDOUtil.getWordList(s);
        if (as.length > 0) {
            stringbuffer.append(as[0].toUpperCase());
            for (int i = 1; i < as.length; ++i) {
                stringbuffer.append('_');
                stringbuffer.append(as[i].toUpperCase());
            }
        }
        return stringbuffer.toString();
    }

    private static String[] getWordList(String s) {
        ArrayList<String> arraylist = new ArrayList<String>();
        int i = s.length();
        int j = 0;
        while (j < i) {
            while (j < i && SDOUtil.isPunct(s.charAt(j))) {
                ++j;
            }
            if (j >= i) break;
            int k = SDOUtil.nextBreak(s, j);
            String s1 = k != -1 ? s.substring(j, k) : s.substring(j);
            arraylist.add(SDOUtil.escape(s1));
            if (k == -1) break;
            j = k;
        }
        return arraylist.toArray(new String[0]);
    }

    private static boolean isPunct(char c) {
        if (c == '-' || c == '.' || c == ':' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de') {
            return true;
        }
        return c == '_' && asWordSeparator;
    }

    private static boolean isUncased(char c) {
        return Character.isLetter(c) && !Character.isUpperCase(c) && !Character.isLowerCase(c);
    }

    private static int nextBreak(String s, int i) {
        int j = s.length();
        for (int k = i; k < j; ++k) {
            char c1;
            char c = s.charAt(k);
            if (c == '_' && !asWordSeparator || k >= j - 1 || (c1 = s.charAt(k + 1)) == '_' && !asWordSeparator) continue;
            if (SDOUtil.isPunct(c1)) {
                return k + 1;
            }
            if (Character.isDigit(c) && !Character.isDigit(c1)) {
                return k + 1;
            }
            if (!Character.isDigit(c) && Character.isDigit(c1)) {
                return k + 1;
            }
            if (Character.isLowerCase(c) && !Character.isLowerCase(c1)) {
                return k + 1;
            }
            if (k < j - 2) {
                char c2 = s.charAt(k + 2);
                if (c2 == '_' && !asWordSeparator) continue;
                if (Character.isUpperCase(c) && Character.isUpperCase(c1) && Character.isLowerCase(c2)) {
                    return k + 1;
                }
            }
            if (Character.isLetter(c) && !Character.isLetter(c1)) {
                return k + 1;
            }
            if (!Character.isLetter(c) && Character.isLetter(c1)) {
                return k + 1;
            }
            if (SDOUtil.isUncased(c) && !SDOUtil.isUncased(c1)) {
                return k + 1;
            }
            if (SDOUtil.isUncased(c) || !SDOUtil.isUncased(c1)) continue;
            return k + 1;
        }
        return -1;
    }

    private static String escape(String s) {
        int i = s.length();
        for (int j = 0; j < i; ++j) {
            if (Character.isJavaIdentifierPart(s.charAt(j))) continue;
            StringBuffer stringbuffer = new StringBuffer(s.substring(0, j));
            SDOUtil.escape(stringbuffer, s, j);
            return stringbuffer.toString();
        }
        return s;
    }

    private static void escape(StringBuffer stringbuffer, String s, int i) {
        int j = s.length();
        for (int k = i; k < j; ++k) {
            char c = s.charAt(k);
            if (Character.isJavaIdentifierPart(c)) {
                stringbuffer.append(c);
                continue;
            }
            stringbuffer.append("_");
            if (c <= '\u000f') {
                stringbuffer.append("000");
            } else if (c <= '\u00ff') {
                stringbuffer.append("00");
            } else if (c <= '\u0fff') {
                stringbuffer.append("0");
            }
            stringbuffer.append(Integer.toString(c, 16));
        }
    }

    private static String escapeUnicode(StringBuffer stringbuffer, char c) {
        String s = Integer.toString(c, 16);
        int i = s.length();
        stringbuffer.setLength(6);
        stringbuffer.setCharAt(0, '\\');
        stringbuffer.setCharAt(1, 'u');
        int j = 2;
        int k = i;
        while (k < 4) {
            stringbuffer.setCharAt(j, '0');
            ++k;
            ++j;
        }
        stringbuffer.replace(j, 6, s);
        return stringbuffer.toString();
    }

    public static String getJavaTypeForProperty(SDOProperty property) {
        if (property.isMany() || property.getType().isXsdList()) {
            return "java.util.List";
        }
        SDOType propertyType = property.getType();
        if (propertyType.isDataType()) {
            Class instanceClass = propertyType.getInstanceClass();
            if (ClassConstants.ABYTE.equals(instanceClass)) {
                return "Byte[]";
            }
            if (ClassConstants.APBYTE.equals(instanceClass)) {
                return "byte[]";
            }
        }
        return propertyType.getInstanceClassName();
    }

    public static String getBuiltInType(String typeName) {
        if (typeName.equals(ClassConstants.PBOOLEAN.getName()) || typeName.equals(ClassConstants.BOOLEAN.getName())) {
            return "Boolean";
        }
        if (typeName.equals(ClassConstants.PBYTE.getName()) || typeName.equals(ClassConstants.BYTE.getName())) {
            return "Byte";
        }
        if (typeName.equals("byte[]") || typeName.equals("Byte[]") || typeName.equals(ClassConstants.APBYTE.getName()) || typeName.equals(ClassConstants.ABYTE.getName())) {
            return "Bytes";
        }
        if (typeName.equals(ClassConstants.PCHAR.getName()) || typeName.equals(ClassConstants.CHAR.getName())) {
            return "Char";
        }
        if (typeName.equals(ClassConstants.PDOUBLE.getName()) || typeName.equals(ClassConstants.DOUBLE.getName())) {
            return "Double";
        }
        if (typeName.equals(ClassConstants.PFLOAT.getName()) || typeName.equals(ClassConstants.FLOAT.getName())) {
            return "Float";
        }
        if (typeName.equals(ClassConstants.PLONG.getName()) || typeName.equals(ClassConstants.LONG.getName())) {
            return "Long";
        }
        if (typeName.equals(ClassConstants.PSHORT.getName()) || typeName.equals(ClassConstants.SHORT.getName())) {
            return "Short";
        }
        if (typeName.equals(ClassConstants.PINT.getName()) || typeName.equals(ClassConstants.INTEGER.getName())) {
            return "Int";
        }
        if (typeName.equals(ClassConstants.STRING.getName())) {
            return "String";
        }
        if (typeName.equals(ClassConstants.BIGINTEGER.getName())) {
            return "BigInteger";
        }
        if (typeName.equals(ClassConstants.BIGDECIMAL.getName())) {
            return "BigDecimal";
        }
        if (typeName.equals(ClassConstants.UTILDATE.getName())) {
            return "Date";
        }
        if (typeName.equals("java.util.List")) {
            return "List";
        }
        return null;
    }
}

