/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib;

import JOscarLib.DataContainer;
import JOscarLib.RawData;

public class Tlv
extends DataContainer {
    private static final int TLV_HEADER_SIZE = 4;
    private RawData type;
    private RawData length;
    private byte[] headerByteArray = new byte[4];

    public Tlv(RawData value, int type) {
        this.type = new RawData(type, 2);
        this.appendRawDataToTlv(value);
    }

    public Tlv(String string, int tlvType) {
        this(new RawData(string), tlvType);
    }

    public Tlv(int val, int tlvType) {
        this(new RawData(val), tlvType);
    }

    public Tlv(int val, int forcedLenght, int tlvType) {
        this(new RawData(val, forcedLenght), tlvType);
    }

    public Tlv(byte[] array, int start) {
        this.headerModified = true;
        byte[] typeArray = new byte[2];
        byte[] lengthArray = new byte[2];
        System.arraycopy(array, start, typeArray, 0, 2);
        this.type = new RawData(typeArray);
        System.arraycopy(array, start + 2, lengthArray, 0, 2);
        this.length = new RawData(lengthArray);
        byte[] valueArray = new byte[this.getLength()];
        System.arraycopy(array, start + 4, valueArray, 0, this.getLength());
        this.appendRawDataToTlv(new RawData(valueArray));
    }

    public void appendRawDataToTlv(RawData data) {
        this.addDataField(data);
    }

    public void appendTlvToTlv(Tlv tlv) {
        this.addDataField(tlv);
    }

    public byte[] getHeaderByteArray() {
        if (this.headerModified) {
            this.length = new RawData(this.getDataFieldByteArray().length, 2);
            System.arraycopy(this.type.getByteArray(), 0, this.headerByteArray, 0, this.type.getByteArray().length);
            System.arraycopy(this.length.getByteArray(), 0, this.headerByteArray, 2, this.length.getByteArray().length);
            this.headerModified = false;
        }
        return this.headerByteArray;
    }

    public int getType() {
        return this.type.getValue();
    }

    public int getLength() {
        return this.length.getValue();
    }

    public int getValue() {
        return ((RawData)this.elementAt(0)).getValue();
    }

    public String getStringValue() {
        return ((RawData)this.elementAt(0)).getStringValue();
    }
}

