/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.util.Vector;
import org.gcube.contentmanagement.blobstorage.resource.RequestObject;
import org.gcube.contentmanagement.blobstorage.service.operation.ChunkProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor {
    final Logger logger = LoggerFactory.getLogger(Monitor.class);
    private Vector<RequestObject> requestQueue = new Vector();

    public synchronized RequestObject getRequest() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getRequest() - start");
        }
        while (this.requestQueue.size() == 0) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                this.logger.error("getRequest()", (Throwable)e);
            }
        }
        RequestObject myFile = this.requestQueue.remove(0);
        this.notifyAll();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getRequest() - end");
        }
        return myFile;
    }

    public synchronized RequestObject getRequest(ChunkProducer producer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getRequest(ChunkProducer) - start");
        }
        while (this.requestQueue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.logger.error("getRequest(ChunkProducer)", (Throwable)e);
            }
        }
        RequestObject myFile = this.requestQueue.remove(0);
        this.notifyAll();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getRequest(ChunkProducer) - end");
        }
        return myFile;
    }

    public synchronized void putRequest(RequestObject richiesta) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("putRequest(MyFile) - start");
            this.logger.debug("request in queue, queue size: " + this.requestQueue.size());
        }
        while (this.requestQueue.size() > 10) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.logger.error("putRequest(MyFile)", (Throwable)e);
            }
        }
        this.requestQueue.addElement(richiesta);
        this.notifyAll();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("putRequest(MyFile) - end");
        }
    }
}

