/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.gcube.contentmanagement.blobstorage.resource.RequestObject;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.operation.UploadOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkConsumer
implements Runnable {
    final Logger logger = LoggerFactory.getLogger(ChunkConsumer.class);
    private Monitor monitor;
    private int id;
    private String[] server;
    private String user;
    private String password;
    private static String bucketName;
    boolean isChunk = false;
    String[] dbNames;
    public static ThreadLocal<TransportManager> client;
    public static ThreadLocal<RequestObject> resource;
    private boolean replaceOpt;
    Thread producer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("run() - start");
        }
        RequestObject request = null;
        Class<ChunkConsumer> clazz = ChunkConsumer.class;
        synchronized (ChunkConsumer.class) {
            request = this.monitor.getRequest();
            resource.set(request);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.connection(resource.get());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("run() - end");
            }
            return;
        }
    }

    private void connection(RequestObject richiesta) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connection(MyFile) - start");
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connection(MyFile) - request fetched: " + resource.get().getKey() + " current Thread: " + Thread.currentThread());
            }
            this.putInTerrastore(resource.get());
        }
        catch (Exception e) {
            this.logger.warn("connection(MyFile)- upload" + e.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connection(MyFile) - retry PUT");
            }
            this.connection(resource.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connection(MyFile) - end");
        }
    }

    public ChunkConsumer(Monitor monitor, int id, String[] server, String user, String password, String[] dbNames, boolean isChunk, String bucket, boolean replaceOption) {
        this.monitor = monitor;
        this.id = id;
        this.server = server;
        this.user = user;
        this.password = password;
        bucketName = bucket;
        this.isChunk = isChunk;
        this.dbNames = dbNames;
        this.replaceOpt = replaceOption;
    }

    private String[] randomizeServer(String[] server) {
        int len = server.length;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("array server length: " + len);
        }
        int n = (int)(Math.random() * 10.0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("random number: " + n);
        }
        int start = 0;
        if (n > 0) {
            start = len % n;
            if (start > 0) {
                --start;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("start index: " + start);
            }
            String temp = server[0];
            server[0] = server[start];
            server[start] = temp;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Server 0: " + server[0]);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void putInTerrastore(RequestObject myFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("putInTerrastore(MyFile) - start");
        }
        long start = 0L;
        if (client.get() == null) {
            start = System.currentTimeMillis();
            Class<ChunkConsumer> clazz = ChunkConsumer.class;
            // MONITORENTER : org.gcube.contentmanagement.blobstorage.service.operation.ChunkConsumer.class
            String[] randomServer = this.randomizeServer(this.server);
            TransportManagerFactory tmf = new TransportManagerFactory(randomServer, null, null);
            client.set(tmf.getTransport(null, "mongo", null, null, myFile.getWriteConcern(), myFile.getReadPreference()));
            // MONITOREXIT : clazz
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("waiting time for upload: " + (System.currentTimeMillis() - start) + " su: " + resource.get().getKey());
            }
        }
        start = System.currentTimeMillis();
        try {
            UploadOperator upload = new UploadOperator(this.server, this.user, this.password, bucketName, this.monitor, this.isChunk, null, this.dbNames);
            client.get().put(upload);
        }
        catch (Exception e) {
            this.logger.error("ERROR IN CLUSTER CONNECTION ", (Throwable)e);
            this.monitor.putRequest(resource.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Time for upload: " + (System.currentTimeMillis() - start) + " on: " + resource.get().getKey());
        }
        if (!this.logger.isDebugEnabled()) return;
        this.logger.debug("putInTerrastore(MyFile) - end");
    }

    static {
        client = new ThreadLocal();
        resource = new ThreadLocal();
    }
}

