/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;

public class DictionarySerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{Hashtable.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && Dictionary.class.isAssignableFrom(clazz);
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        Dictionary ht = (Dictionary)o;
        JSONObject obj = new JSONObject();
        JSONObject mapdata = new JSONObject();
        try {
            if (this.ser.getMarshallClassHints()) {
                obj.put("javaClass", (Object)o.getClass().getName());
            }
            obj.put("map", (Object)mapdata);
            state.push(o, mapdata, "map");
        }
        catch (JSONException e) {
            throw new MarshallException("Could not put data" + e.getMessage(), e);
        }
        Object key = null;
        try {
            Enumeration en = ht.keys();
            while (en.hasMoreElements()) {
                key = en.nextElement();
                String keyString = key.toString();
                Object json = this.ser.marshall(state, mapdata, ht.get(key), keyString);
                if (JSONSerializer.CIRC_REF_OR_DUPLICATE == json) continue;
                mapdata.put(keyString, json);
            }
        }
        catch (MarshallException e) {
            throw new MarshallException("map key " + key + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new MarshallException("map key " + key + " " + e.getMessage(), e);
        }
        finally {
            state.pop();
        }
        return obj;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jsonmap;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!java_class.equals("java.util.Dictionary") && !java_class.equals("java.util.Hashtable")) {
            throw new UnmarshallException("not a Dictionary");
        }
        try {
            jsonmap = jso.getJSONObject("map");
        }
        catch (JSONException e) {
            throw new UnmarshallException("map missing", e);
        }
        if (jsonmap == null) {
            throw new UnmarshallException("map missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        state.setSerialized(o, m);
        Iterator i = jsonmap.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                m.setMismatch(this.ser.tryUnmarshall(state, null, jsonmap.get(key)).max(m).getMismatch());
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), e);
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jsonmap;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!java_class.equals("java.util.Dictionary") && !java_class.equals("java.util.Hashtable")) {
            throw new UnmarshallException("not a Dictionary");
        }
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        try {
            jsonmap = jso.getJSONObject("map");
        }
        catch (JSONException e) {
            throw new UnmarshallException("map missing", e);
        }
        if (jsonmap == null) {
            throw new UnmarshallException("map missing");
        }
        state.setSerialized(o, ht);
        Iterator i = jsonmap.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                ht.put(key, this.ser.unmarshall(state, null, jsonmap.get(key)));
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), e);
        }
        return ht;
    }
}

