/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.cataloggen.CatalogBuilder;
import thredds.cataloggen.CatalogBuilderHelper;
import thredds.cataloggen.CatalogRefExpander;
import thredds.cataloggen.CollectionLevelScanner;
import thredds.cataloggen.DatasetEnhancer;
import thredds.cataloggen.InvCrawlablePair;
import thredds.cataloggen.ProxyDatasetHandler;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.CrawlableDatasetLabeler;
import thredds.crawlabledataset.CrawlableDatasetSorter;

public class StandardCatalogBuilder
implements CatalogBuilder {
    private static Logger log = LoggerFactory.getLogger(StandardCatalogBuilder.class);
    private String collectionPath;
    private String collectionName;
    private CrawlableDataset collectionCrDs;
    private CrawlableDatasetFilter filter;
    private InvService service;
    private String collectionId;
    private CrawlableDatasetLabeler identifier;
    private CrawlableDatasetLabeler namer;
    private boolean doAddDatasetSize;
    private CrawlableDatasetSorter sorter;
    private Map proxyDatasetHandlers;
    private List childEnhancerList;
    private InvDatasetImpl topLevelMetadataContainer;
    private CatalogRefExpander catalogRefExpander;

    public StandardCatalogBuilder(String collectionPath, String collectionName, CrawlableDataset collectionCrDs, CrawlableDatasetFilter filter, InvService service, String collectionId, CrawlableDatasetLabeler identifier, CrawlableDatasetLabeler namer, boolean doAddDatasetSize, CrawlableDatasetSorter sorter, Map proxyDatasetHandlers, List childEnhancerList, InvDatasetImpl topLevelMetadataContainer, CatalogRefExpander catalogRefExpander) {
        this.collectionPath = collectionPath;
        this.collectionName = collectionName;
        this.collectionCrDs = collectionCrDs;
        this.filter = filter;
        this.service = service;
        this.collectionId = collectionId;
        this.identifier = identifier;
        this.namer = namer;
        this.doAddDatasetSize = doAddDatasetSize;
        this.sorter = sorter;
        this.proxyDatasetHandlers = proxyDatasetHandlers;
        this.childEnhancerList = childEnhancerList;
        this.topLevelMetadataContainer = topLevelMetadataContainer;
        this.catalogRefExpander = catalogRefExpander;
    }

    public CrawlableDataset requestCrawlableDataset(String path) throws IOException {
        String parentPath;
        String dsName;
        CrawlableDataset crDs = CatalogBuilderHelper.verifyDescendantDataset(this.collectionCrDs, path, this.filter);
        if (crDs != null) {
            return crDs;
        }
        int indexLastSlash = path.lastIndexOf("/");
        if (indexLastSlash != -1) {
            dsName = path.substring(indexLastSlash + 1);
            parentPath = path.substring(0, indexLastSlash);
        } else {
            dsName = path;
            parentPath = "";
        }
        CrawlableDataset parentCrDs = CatalogBuilderHelper.verifyDescendantDataset(this.collectionCrDs, parentPath, this.filter);
        if (parentCrDs == null) {
            log.debug("requestCrawlableDataset(): Parent dataset <" + parentPath + "> not allowed by filter.");
            return null;
        }
        if (!parentCrDs.isCollection()) {
            log.debug("requestCrawlableDataset(): Parent dataset <" + parentPath + "> is not a collection dataset.");
            return null;
        }
        ProxyDatasetHandler pdh = (ProxyDatasetHandler)this.proxyDatasetHandlers.get(dsName);
        if (pdh == null) {
            log.debug("requestCrawlableDataset(): Dataset name <" + dsName + "> has no corresponding proxy dataset handler.");
            return null;
        }
        if (pdh.isProxyDatasetResolver()) {
            log.debug("requestCrawlableDataset(): Proxy dataset <" + dsName + "> is a resolver, not valid dataset request.");
            return null;
        }
        CollectionLevelScanner scanner = this.setupAndScan(parentCrDs, null);
        List atomicDsInfo = scanner.getAtomicDsInfo();
        InvCrawlablePair dsInfo = pdh.getActualDataset(atomicDsInfo);
        return dsInfo.getCrawlableDataset();
    }

    public InvCatalogImpl generateCatalog(CrawlableDataset catalogCrDs) throws IOException {
        CollectionLevelScanner scanner = this.setupAndScan(catalogCrDs, null);
        InvCatalogImpl catalog = scanner.generateCatalog();
        boolean needFinish = false;
        if (this.catalogRefExpander != null) {
            ArrayList catRefInfoList = new ArrayList(scanner.getCatRefInfo());
            while (catRefInfoList.size() > 0) {
                InvCrawlablePair curCatRefInfo = (InvCrawlablePair)catRefInfoList.get(0);
                if (this.catalogRefExpander.expandCatalogRef(curCatRefInfo)) {
                    CollectionLevelScanner curScanner = new CollectionLevelScanner(this.collectionPath, this.collectionCrDs, catalogCrDs, curCatRefInfo.getCrawlableDataset(), this.filter, this.service);
                    curScanner.setCollectionId(this.collectionId);
                    curScanner.setIdentifier(this.identifier);
                    curScanner.setNamer(this.namer);
                    curScanner.setDoAddDataSize(this.doAddDatasetSize);
                    curScanner.setSorter(this.sorter);
                    curScanner.setProxyDsHandlers(this.proxyDatasetHandlers);
                    if (this.childEnhancerList != null) {
                        Iterator it = this.childEnhancerList.iterator();
                        while (it.hasNext()) {
                            curScanner.addChildEnhancer((DatasetEnhancer)it.next());
                        }
                    }
                    curScanner.scan();
                    InvCatalogImpl curCatalog = curScanner.generateCatalog();
                    catRefInfoList.addAll(curScanner.getCatRefInfo());
                    InvDataset curTopDs = curCatalog.getDataset();
                    InvDataset targetDs = curCatRefInfo.getInvDataset();
                    InvDataset targetParentDs = curCatRefInfo.getInvDataset().getParent();
                    ((InvDatasetImpl)targetParentDs).removeDataset((InvDatasetImpl)targetDs);
                    ((InvDatasetImpl)targetParentDs).addDataset((InvDatasetImpl)curTopDs);
                    needFinish = true;
                }
                catRefInfoList.remove(0);
            }
        }
        if (needFinish) {
            catalog.finish();
        }
        return catalog;
    }

    public InvCatalogImpl generateProxyDsResolverCatalog(CrawlableDataset catalogCrDs, ProxyDatasetHandler pdh) throws IOException {
        if (catalogCrDs == null || pdh == null) {
            throw new IllegalArgumentException("Null parameters not allowed.");
        }
        if (!this.proxyDatasetHandlers.containsValue(pdh)) {
            throw new IllegalArgumentException("Unknown ProxyDatasetHandler.");
        }
        CollectionLevelScanner scanner = this.setupAndScan(catalogCrDs, null);
        return scanner.generateProxyDsResolverCatalog(pdh);
    }

    private CollectionLevelScanner setupAndScan(CrawlableDataset catalogCrDs, CrawlableDataset currentCrDs) throws IOException {
        CollectionLevelScanner scanner = new CollectionLevelScanner(this.collectionPath, this.collectionCrDs, catalogCrDs, currentCrDs, this.filter, this.service);
        scanner.setCollectionId(this.collectionId);
        scanner.setCollectionName(this.collectionName);
        scanner.setIdentifier(this.identifier);
        scanner.setNamer(this.namer);
        scanner.setDoAddDataSize(this.doAddDatasetSize);
        scanner.setSorter(this.sorter);
        scanner.setProxyDsHandlers(this.proxyDatasetHandlers);
        if (this.childEnhancerList != null) {
            Iterator it = this.childEnhancerList.iterator();
            while (it.hasNext()) {
                scanner.addChildEnhancer((DatasetEnhancer)it.next());
            }
        }
        scanner.setTopLevelMetadataContainer(this.topLevelMetadataContainer);
        scanner.scan();
        return scanner;
    }

    public Document generateCatalogAsDocument(CrawlableDataset catalogCrDs) throws IOException {
        return CatalogBuilderHelper.convertCatalogToDocument(this.generateCatalog(catalogCrDs));
    }

    public String generateCatalogAsString(CrawlableDataset catalogCrDs) throws IOException {
        return CatalogBuilderHelper.convertCatalogToString(this.generateCatalog(catalogCrDs));
    }
}

