/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GlobPattern {
    private static Logger log = LoggerFactory.getLogger(GlobPattern.class);
    private static final char ALL = '*';
    public static final String WILDCARD_ALL = "*";
    private final String pattern;
    private final char[] patternChars;
    private final boolean matchesAll;
    private final boolean containsWildcard;

    private GlobPattern(String pattern) {
        this.pattern = pattern;
        this.matchesAll = WILDCARD_ALL.equals(pattern);
        this.containsWildcard = pattern.indexOf(42) > -1;
        this.patternChars = pattern.toCharArray();
    }

    static GlobPattern create(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        return new GlobPattern(pattern);
    }

    boolean matches(String toMatch) {
        if (this.matchesAll) {
            return true;
        }
        if (toMatch == null) {
            return false;
        }
        if (this.containsWildcard) {
            return GlobPattern.matches(this.patternChars, toMatch.toCharArray());
        }
        return Text.isDescendantOrEqual((String)this.pattern, (String)toMatch);
    }

    boolean matches(Item itemToMatch) {
        try {
            return this.matches(itemToMatch.getPath());
        }
        catch (RepositoryException e) {
            log.error("Unable to determine match.", (Object)e.getMessage());
            return false;
        }
    }

    private static boolean matches(char[] patternChars, char[] toMatch) {
        for (int i = 0; i < patternChars.length; ++i) {
            if (patternChars[i] == '*') {
                return true;
            }
            if (i < toMatch.length && patternChars[i] == toMatch[i]) continue;
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toString() {
        return this.pattern;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GlobPattern) {
            return this.pattern.equals(((GlobPattern)obj).pattern);
        }
        return false;
    }
}

