/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHClassDeclaration;
import bsh.BSHFormalParameters;
import bsh.BSHMethodDeclaration;
import bsh.BSHReturnType;
import bsh.BSHTypedVariableDeclaration;
import bsh.BSHVariableDeclarator;
import bsh.BshClassManager;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.ClassGenerator;
import bsh.ClassGeneratorUtil;
import bsh.DelayedEvalBshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.This;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.Variable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ClassGeneratorImpl
extends ClassGenerator {
    public Class generateClass(String string, Modifiers modifiers, Class[] classArray, Class clazz, BSHBlock bSHBlock, boolean bl, CallStack callStack, Interpreter interpreter) throws EvalError {
        return ClassGeneratorImpl.generateClassImpl(string, modifiers, classArray, clazz, bSHBlock, bl, callStack, interpreter);
    }

    public Object invokeSuperclassMethod(BshClassManager bshClassManager, Object object, String string, Object[] objectArray) throws UtilEvalError, ReflectError, InvocationTargetException {
        return ClassGeneratorImpl.invokeSuperclassMethodImpl(bshClassManager, object, string, objectArray);
    }

    public void setInstanceNameSpaceParent(Object object, String string, NameSpace nameSpace) {
        This this_ = ClassGeneratorUtil.getClassInstanceThis(object, string);
        this_.getNameSpace().setParent(nameSpace);
    }

    public static Class generateClassImpl(String string, Modifiers modifiers, Class[] classArray, Class clazz, BSHBlock bSHBlock, boolean bl, CallStack callStack, Interpreter interpreter) throws EvalError {
        Object object;
        try {
            Capabilities.setAccessibility(true);
        }
        catch (Capabilities.Unavailable unavailable) {
            throw new EvalError("Defining classes currently requires reflective Accessibility.", bSHBlock, callStack);
        }
        NameSpace nameSpace = callStack.top();
        String string2 = nameSpace.getPackage();
        String string3 = nameSpace.isClass ? nameSpace.getName() + "$" + string : string;
        String string4 = string2 == null ? string3 : string2 + "." + string3;
        BshClassManager bshClassManager = interpreter.getClassManager();
        bshClassManager.definingClass(string4);
        NameSpace nameSpace2 = new NameSpace(nameSpace, string3);
        nameSpace2.isClass = true;
        callStack.push(nameSpace2);
        bSHBlock.evalBlock(callStack, interpreter, true, ClassNodeFilter.CLASSCLASSES);
        Variable[] variableArray = ClassGeneratorImpl.getDeclaredVariables(bSHBlock, callStack, interpreter, string2);
        DelayedEvalBshMethod[] delayedEvalBshMethodArray = ClassGeneratorImpl.getDeclaredMethods(bSHBlock, callStack, interpreter, string2);
        ClassGeneratorUtil classGeneratorUtil = new ClassGeneratorUtil(modifiers, string3, string2, clazz, classArray, variableArray, delayedEvalBshMethodArray, nameSpace2, bl);
        byte[] byArray = classGeneratorUtil.generateClass();
        String string5 = System.getProperty("debugClasses");
        if (string5 != null) {
            try {
                object = new FileOutputStream(string5 + "/" + string3 + ".class");
                ((FileOutputStream)object).write(byArray);
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = bshClassManager.defineClass(string4, byArray);
        nameSpace.importClass(string4.replace('$', '.'));
        try {
            nameSpace2.setLocalVariable("_bshInstanceInitializer", bSHBlock, false);
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("unable to init static: " + utilEvalError);
        }
        nameSpace2.setClassStatic((Class)object);
        bSHBlock.evalBlock(callStack, interpreter, true, ClassNodeFilter.CLASSSTATIC);
        callStack.pop();
        if (!((Class)object).isInterface()) {
            String string6 = "_bshStatic" + string3;
            try {
                LHS lHS = Reflect.getLHSStaticField((Class)object, string6);
                lHS.assign(nameSpace2.getThis(interpreter), false);
            }
            catch (Exception exception) {
                throw new InterpreterError("Error in class gen setup: " + exception);
            }
        }
        bshClassManager.doneDefiningClass(string4);
        return object;
    }

    static Variable[] getDeclaredVariables(BSHBlock bSHBlock, CallStack callStack, Interpreter interpreter, String string) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        int n = 0;
        while (n < bSHBlock.jjtGetNumChildren()) {
            SimpleNode simpleNode = (SimpleNode)bSHBlock.jjtGetChild(n);
            if (simpleNode instanceof BSHTypedVariableDeclaration) {
                BSHTypedVariableDeclaration bSHTypedVariableDeclaration = (BSHTypedVariableDeclaration)simpleNode;
                Modifiers modifiers = bSHTypedVariableDeclaration.modifiers;
                String string2 = bSHTypedVariableDeclaration.getTypeDescriptor(callStack, interpreter, string);
                BSHVariableDeclarator[] bSHVariableDeclaratorArray = bSHTypedVariableDeclaration.getDeclarators();
                int n2 = 0;
                while (n2 < bSHVariableDeclaratorArray.length) {
                    String string3 = bSHVariableDeclaratorArray[n2].name;
                    try {
                        Variable variable = new Variable(string3, string2, null, modifiers);
                        arrayList.add(variable);
                    }
                    catch (UtilEvalError utilEvalError) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList.toArray(new Variable[0]);
    }

    static DelayedEvalBshMethod[] getDeclaredMethods(BSHBlock bSHBlock, CallStack callStack, Interpreter interpreter, String string) throws EvalError {
        ArrayList<DelayedEvalBshMethod> arrayList = new ArrayList<DelayedEvalBshMethod>();
        int n = 0;
        while (n < bSHBlock.jjtGetNumChildren()) {
            SimpleNode simpleNode = (SimpleNode)bSHBlock.jjtGetChild(n);
            if (simpleNode instanceof BSHMethodDeclaration) {
                BSHMethodDeclaration bSHMethodDeclaration = (BSHMethodDeclaration)simpleNode;
                bSHMethodDeclaration.insureNodesParsed();
                Modifiers modifiers = bSHMethodDeclaration.modifiers;
                String string2 = bSHMethodDeclaration.name;
                String string3 = bSHMethodDeclaration.getReturnTypeDescriptor(callStack, interpreter, string);
                BSHReturnType bSHReturnType = bSHMethodDeclaration.getReturnTypeNode();
                BSHFormalParameters bSHFormalParameters = bSHMethodDeclaration.paramsNode;
                String[] stringArray = bSHFormalParameters.getTypeDescriptors(callStack, interpreter, string);
                DelayedEvalBshMethod delayedEvalBshMethod = new DelayedEvalBshMethod(string2, string3, bSHReturnType, bSHMethodDeclaration.paramsNode.getParamNames(), stringArray, bSHFormalParameters, bSHMethodDeclaration.blockNode, null, modifiers, callStack, interpreter);
                arrayList.add(delayedEvalBshMethod);
            }
            ++n;
        }
        return arrayList.toArray(new DelayedEvalBshMethod[0]);
    }

    public static Object invokeSuperclassMethodImpl(BshClassManager bshClassManager, Object object, String string, Object[] objectArray) throws UtilEvalError, ReflectError, InvocationTargetException {
        String string2 = "_bshSuper" + string;
        Class<?> clazz = object.getClass();
        Method method = Reflect.resolveJavaMethod(bshClassManager, clazz, string2, Types.getTypes(objectArray), false);
        if (method != null) {
            return Reflect.invokeMethod(method, object, objectArray);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        method = Reflect.resolveExpectedJavaMethod(bshClassManager, clazz2, object, string, objectArray, false);
        return Reflect.invokeMethod(method, object, objectArray);
    }

    static class ClassNodeFilter
    implements BSHBlock.NodeFilter {
        public static final int STATIC = 0;
        public static final int INSTANCE = 1;
        public static final int CLASSES = 2;
        public static ClassNodeFilter CLASSSTATIC = new ClassNodeFilter(0);
        public static ClassNodeFilter CLASSINSTANCE = new ClassNodeFilter(1);
        public static ClassNodeFilter CLASSCLASSES = new ClassNodeFilter(2);
        int context;

        private ClassNodeFilter(int n) {
            this.context = n;
        }

        public boolean isVisible(SimpleNode simpleNode) {
            if (this.context == 2) {
                return simpleNode instanceof BSHClassDeclaration;
            }
            if (simpleNode instanceof BSHClassDeclaration) {
                return false;
            }
            if (this.context == 0) {
                return this.isStatic(simpleNode);
            }
            if (this.context == 1) {
                return !this.isStatic(simpleNode);
            }
            return true;
        }

        boolean isStatic(SimpleNode simpleNode) {
            if (simpleNode instanceof BSHTypedVariableDeclaration) {
                return ((BSHTypedVariableDeclaration)simpleNode).modifiers != null && ((BSHTypedVariableDeclaration)simpleNode).modifiers.hasModifier("static");
            }
            if (simpleNode instanceof BSHMethodDeclaration) {
                return ((BSHMethodDeclaration)simpleNode).modifiers != null && ((BSHMethodDeclaration)simpleNode).modifiers.hasModifier("static");
            }
            if (simpleNode instanceof BSHBlock) {
                return false;
            }
            return false;
        }
    }
}

