/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class IOUtils {
    public static void readFully(InputStream inp, byte[] destination) throws IOException {
        IOUtils.readFully(inp, destination, 0, destination.length);
    }

    public static void readFully(InputStream inp, byte[] destination, int offset, int length) throws IOException {
        int r;
        for (int read = 0; read < length; read += r) {
            r = inp.read(destination, offset + read, length - read);
            if (r != -1) continue;
            throw new IOException("Asked to read " + length + " bytes from " + offset + " but hit EoF at " + read);
        }
    }

    public static int toInt(byte b) {
        if (b < 0) {
            return b & 0xFF;
        }
        return b;
    }

    public static byte fromInt(int i) {
        if (i > 256) {
            throw new IllegalArgumentException("Number " + i + " too big");
        }
        if (i > 127) {
            return (byte)(i - 256);
        }
        return (byte)i;
    }

    public static int getInt2(byte[] data) {
        return IOUtils.getInt2(data, 0);
    }

    public static int getInt2(byte[] data, int offset) {
        int i = offset;
        int b0 = data[i++] & 0xFF;
        int b1 = data[i++] & 0xFF;
        return IOUtils.getInt(b0, b1);
    }

    public static long getInt3(byte[] data) {
        return IOUtils.getInt3(data, 0);
    }

    public static long getInt3(byte[] data, int offset) {
        int i = offset;
        int b0 = data[i++] & 0xFF;
        int b1 = data[i++] & 0xFF;
        int b2 = data[i++] & 0xFF;
        return IOUtils.getInt(b0, b1, b2);
    }

    public static long getInt4(byte[] data) {
        return IOUtils.getInt4(data, 0);
    }

    public static long getInt4(byte[] data, int offset) {
        int i = offset;
        int b0 = data[i++] & 0xFF;
        int b1 = data[i++] & 0xFF;
        int b2 = data[i++] & 0xFF;
        int b3 = data[i++] & 0xFF;
        return IOUtils.getInt(b0, b1, b2, b3);
    }

    public static long getInt8(byte[] data) {
        return IOUtils.getInt8(data, 0);
    }

    public static long getInt8(byte[] data, int offset) {
        int i = offset;
        int b0 = data[i++] & 0xFF;
        int b1 = data[i++] & 0xFF;
        int b2 = data[i++] & 0xFF;
        int b3 = data[i++] & 0xFF;
        int b4 = data[i++] & 0xFF;
        int b5 = data[i++] & 0xFF;
        int b6 = data[i++] & 0xFF;
        int b7 = data[i++] & 0xFF;
        return IOUtils.getInt(b0, b1, b2, b3, b4, b5, b6, b7);
    }

    public static int getInt(int i0, int i1) {
        return (i1 << 8) + (i0 << 0);
    }

    public static long getInt(int i0, int i1, int i2) {
        return (i2 << 16) + (i1 << 8) + (i0 << 0);
    }

    public static long getInt(int i0, int i1, int i2, int i3) {
        return (i3 << 24) + (i2 << 16) + (i1 << 8) + (i0 << 0);
    }

    public static long getInt(int i0, int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        return (long)(i7 << 56) + (long)(i6 << 48) + (long)(i5 << 40) + (long)(i4 << 32) + (long)(i3 << 24) + (long)(i2 << 16) + (long)(i1 << 8) + (long)(i0 << 0);
    }

    public static int getInt2BE(byte[] data) {
        return IOUtils.getInt2BE(data, 0);
    }

    public static int getInt2BE(byte[] data, int offset) {
        int i = offset;
        int b0 = data[i++] & 0xFF;
        int b1 = data[i++] & 0xFF;
        return IOUtils.getIntBE(b0, b1);
    }

    public static long getInt3BE(byte[] data) {
        return IOUtils.getInt3BE(data, 0);
    }

    public static long getInt3BE(byte[] data, int offset) {
        int i = offset;
        int b0 = data[i++] & 0xFF;
        int b1 = data[i++] & 0xFF;
        int b2 = data[i++] & 0xFF;
        return IOUtils.getIntBE(b0, b1, b2);
    }

    public static long getInt4BE(byte[] data) {
        return IOUtils.getInt4BE(data, 0);
    }

    public static long getInt4BE(byte[] data, int offset) {
        int i = offset;
        int b0 = data[i++] & 0xFF;
        int b1 = data[i++] & 0xFF;
        int b2 = data[i++] & 0xFF;
        int b3 = data[i++] & 0xFF;
        return IOUtils.getIntBE(b0, b1, b2, b3);
    }

    public static int getIntBE(int i0, int i1) {
        return (i0 << 8) + (i1 << 0);
    }

    public static long getIntBE(int i0, int i1, int i2) {
        return (i0 << 16) + (i1 << 8) + (i2 << 0);
    }

    public static long getIntBE(int i0, int i1, int i2, int i3) {
        return (i0 << 24) + (i1 << 16) + (i2 << 8) + (i3 << 0);
    }

    public static void writeInt2(OutputStream out, int v) throws IOException {
        byte[] b2 = new byte[2];
        IOUtils.putInt2(b2, 0, v);
        out.write(b2);
    }

    public static void putInt2(byte[] data, int offset, int v) {
        int i = offset;
        data[i++] = (byte)(v >>> 0 & 0xFF);
        data[i++] = (byte)(v >>> 8 & 0xFF);
    }

    public static void writeInt3(OutputStream out, long v) throws IOException {
        byte[] b3 = new byte[3];
        IOUtils.putInt3(b3, 0, v);
        out.write(b3);
    }

    public static void putInt3(byte[] data, int offset, long v) {
        int i = offset;
        data[i++] = (byte)(v >>> 0 & 0xFFL);
        data[i++] = (byte)(v >>> 8 & 0xFFL);
        data[i++] = (byte)(v >>> 16 & 0xFFL);
    }

    public static void writeInt4(OutputStream out, long v) throws IOException {
        byte[] b4 = new byte[4];
        IOUtils.putInt4(b4, 0, v);
        out.write(b4);
    }

    public static void putInt4(byte[] data, int offset, long v) {
        int i = offset;
        data[i++] = (byte)(v >>> 0 & 0xFFL);
        data[i++] = (byte)(v >>> 8 & 0xFFL);
        data[i++] = (byte)(v >>> 16 & 0xFFL);
        data[i++] = (byte)(v >>> 24 & 0xFFL);
    }

    public static void writeInt8(OutputStream out, long v) throws IOException {
        byte[] b8 = new byte[8];
        IOUtils.putInt8(b8, 0, v);
        out.write(b8);
    }

    public static void putInt8(byte[] data, int offset, long v) {
        int i = offset;
        data[i++] = (byte)(v >>> 0 & 0xFFL);
        data[i++] = (byte)(v >>> 8 & 0xFFL);
        data[i++] = (byte)(v >>> 16 & 0xFFL);
        data[i++] = (byte)(v >>> 24 & 0xFFL);
        data[i++] = (byte)(v >>> 32 & 0xFFL);
        data[i++] = (byte)(v >>> 40 & 0xFFL);
        data[i++] = (byte)(v >>> 48 & 0xFFL);
        data[i++] = (byte)(v >>> 56 & 0xFFL);
    }

    public static void writeInt2BE(OutputStream out, int v) throws IOException {
        byte[] b2 = new byte[2];
        IOUtils.putInt2BE(b2, 0, v);
        out.write(b2);
    }

    public static void putInt2BE(byte[] data, int offset, int v) {
        int i = offset;
        data[i + 1] = (byte)(v >>> 0 & 0xFF);
        data[i + 0] = (byte)(v >>> 8 & 0xFF);
    }

    public static void writeInt3BE(OutputStream out, long v) throws IOException {
        byte[] b3 = new byte[3];
        IOUtils.putInt3BE(b3, 0, v);
        out.write(b3);
    }

    public static void putInt3BE(byte[] data, int offset, long v) {
        int i = offset;
        data[i + 2] = (byte)(v >>> 0 & 0xFFL);
        data[i + 1] = (byte)(v >>> 8 & 0xFFL);
        data[i + 0] = (byte)(v >>> 16 & 0xFFL);
    }

    public static void writeInt4BE(OutputStream out, long v) throws IOException {
        byte[] b4 = new byte[4];
        IOUtils.putInt4BE(b4, 0, v);
        out.write(b4);
    }

    public static void putInt4BE(byte[] data, int offset, long v) {
        int i = offset;
        data[i + 3] = (byte)(v >>> 0 & 0xFFL);
        data[i + 2] = (byte)(v >>> 8 & 0xFFL);
        data[i + 1] = (byte)(v >>> 16 & 0xFFL);
        data[i + 0] = (byte)(v >>> 24 & 0xFFL);
    }

    public static String getUTF8(byte[] data, int offset, int length) {
        try {
            return new String(data, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Broken JVM, UTF-8 not found", e);
        }
    }

    public static int putUTF8(byte[] data, int offset, String str) {
        try {
            byte[] s = str.getBytes("UTF-8");
            System.arraycopy(s, 0, data, offset, s.length);
            return s.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Broken JVM, UTF-8 not found", e);
        }
    }

    public static void writeUTF8(OutputStream out, String str) throws IOException {
        try {
            byte[] s = str.getBytes("UTF-8");
            out.write(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Broken JVM, UTF-8 not found", e);
        }
    }

    public static void writeUTF8WithLength(OutputStream out, String str) throws IOException {
        try {
            byte[] s = str.getBytes("UTF-8");
            IOUtils.writeInt4(out, s.length);
            out.write(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Broken JVM, UTF-8 not found", e);
        }
    }
}

