/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ListTypeConstants;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.service.base.OrgLaborLocalServiceBaseImpl;
import java.util.List;

public class OrgLaborLocalServiceImpl
extends OrgLaborLocalServiceBaseImpl {
    public OrgLabor addOrgLabor(long organizationId, int typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException, SystemException {
        this.validate(typeId);
        long orgLaborId = this.counterLocalService.increment();
        OrgLabor orgLabor = this.orgLaborPersistence.create(orgLaborId);
        orgLabor.setOrganizationId(organizationId);
        orgLabor.setTypeId(typeId);
        orgLabor.setSunOpen(sunOpen);
        orgLabor.setSunClose(sunClose);
        orgLabor.setMonOpen(monOpen);
        orgLabor.setMonClose(monClose);
        orgLabor.setTueOpen(tueOpen);
        orgLabor.setTueClose(tueClose);
        orgLabor.setWedOpen(wedOpen);
        orgLabor.setWedClose(wedClose);
        orgLabor.setThuOpen(thuOpen);
        orgLabor.setThuClose(thuClose);
        orgLabor.setFriOpen(friOpen);
        orgLabor.setFriClose(friClose);
        orgLabor.setSatOpen(satOpen);
        orgLabor.setSatClose(satClose);
        this.orgLaborPersistence.update((BaseModel)orgLabor);
        return orgLabor;
    }

    public List<OrgLabor> getOrgLabors(long organizationId) throws SystemException {
        return this.orgLaborPersistence.findByOrganizationId(organizationId);
    }

    public OrgLabor updateOrgLabor(long orgLaborId, int typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException, SystemException {
        this.validate(typeId);
        OrgLabor orgLabor = this.orgLaborPersistence.findByPrimaryKey(orgLaborId);
        orgLabor.setTypeId(typeId);
        orgLabor.setSunOpen(sunOpen);
        orgLabor.setSunClose(sunClose);
        orgLabor.setMonOpen(monOpen);
        orgLabor.setMonClose(monClose);
        orgLabor.setTueOpen(tueOpen);
        orgLabor.setTueClose(tueClose);
        orgLabor.setWedOpen(wedOpen);
        orgLabor.setWedClose(wedClose);
        orgLabor.setThuOpen(thuOpen);
        orgLabor.setThuClose(thuClose);
        orgLabor.setFriOpen(friOpen);
        orgLabor.setFriClose(friClose);
        orgLabor.setSatOpen(satOpen);
        orgLabor.setSatClose(satClose);
        this.orgLaborPersistence.update((BaseModel)orgLabor);
        return orgLabor;
    }

    protected void validate(int typeId) throws PortalException, SystemException {
        this.listTypeService.validate(typeId, ListTypeConstants.ORGANIZATION_SERVICE);
    }
}

