/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class LanguageResources {
    private static Log _log = LogFactoryUtil.getLog(LanguageResources.class);
    private static Locale _blankLocale = new Locale("");
    private static String[] _configNames;
    private static Map<Locale, Map<String, String>> _languageMaps;

    static {
        _languageMaps = new ConcurrentHashMap<Locale, Map<String, String>>(64);
    }

    public static String fixValue(String value) {
        if (value.endsWith(" (Automatic Copy)")) {
            value = value.substring(0, value.length() - " (Automatic Copy)".length());
        }
        if (value.endsWith(" (Automatic Translation)")) {
            value = value.substring(0, value.length() - " (Automatic Translation)".length());
        }
        return value;
    }

    public static void fixValues(Map<String, String> languageMap, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = LanguageResources.fixValue(value);
            languageMap.put(key, value);
        }
    }

    public static String getMessage(Locale locale, String key) {
        String value;
        if (locale == null) {
            return null;
        }
        Map<String, String> languageMap = _languageMaps.get(locale);
        if (languageMap == null) {
            languageMap = LanguageResources._loadLocale(locale);
        }
        if ((value = languageMap.get(key)) == null) {
            return LanguageResources.getMessage(LanguageResources.getSuperLocale(locale), key);
        }
        return value;
    }

    public static Locale getSuperLocale(Locale locale) {
        String variant = locale.getVariant();
        if (variant.length() > 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        String country = locale.getCountry();
        if (country.length() > 0) {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (priorityLocale != null && !locale.equals(priorityLocale)) {
                return new Locale(priorityLocale.getLanguage(), priorityLocale.getCountry());
            }
            return LocaleUtil.fromLanguageId((String)locale.getLanguage(), (boolean)false, (boolean)true);
        }
        String language = locale.getLanguage();
        if (language.length() > 0) {
            return _blankLocale;
        }
        return null;
    }

    public static Map<String, String> putLanguageMap(Locale locale, Map<String, String> languageMap) {
        Map<String, String> oldLanguageMap = _languageMaps.get(locale);
        if (oldLanguageMap == null) {
            LanguageResources._loadLocale(locale);
            oldLanguageMap = _languageMaps.get(locale);
        }
        HashMap<String, String> newLanguageMap = new HashMap<String, String>();
        if (oldLanguageMap != null) {
            newLanguageMap.putAll(oldLanguageMap);
        }
        newLanguageMap.putAll(languageMap);
        _languageMaps.put(locale, newLanguageMap);
        return oldLanguageMap;
    }

    public void setConfig(String config) {
        _configNames = StringUtil.split((String)config.replace('.', '/'));
    }

    private static Map<String, String> _loadLocale(Locale locale) {
        Map<String, String> languageMap = null;
        if (_configNames.length > 0) {
            String localeName = locale.toString();
            languageMap = new HashMap();
            String[] stringArray = _configNames;
            int n = _configNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                StringBundler sb = new StringBundler(4);
                sb.append(name);
                if (localeName.length() > 0) {
                    sb.append("_");
                    sb.append(localeName);
                }
                sb.append(".properties");
                Properties properties = LanguageResources._loadProperties(sb.toString());
                LanguageResources.fixValues(languageMap, properties);
                ++n2;
            }
        } else {
            languageMap = Collections.emptyMap();
        }
        _languageMaps.put(locale, languageMap);
        return languageMap;
    }

    private static Properties _loadProperties(String name) {
        Properties properties;
        block8: {
            properties = new Properties();
            try {
                ClassLoader classLoader = LanguageResources.class.getClassLoader();
                Enumeration<URL> enu = classLoader.getResources(name);
                if (_log.isDebugEnabled() && !enu.hasMoreElements()) {
                    _log.debug((Object)("No resources found for " + name));
                }
                while (enu.hasMoreElements()) {
                    URL url = enu.nextElement();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Loading " + name + " from " + url));
                    }
                    InputStream inputStream = url.openStream();
                    try {
                        Properties inputStreamProperties = PropertiesUtil.load((InputStream)inputStream, (String)"UTF-8");
                        properties.putAll((Map<?, ?>)inputStreamProperties);
                        if (!_log.isInfoEnabled()) continue;
                        _log.info((Object)("Loading " + url + " with " + inputStreamProperties.size() + " values"));
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return properties;
    }
}

