/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.DBSemaphore;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Util;

public class StdRowLockSemaphore
extends DBSemaphore {
    public static final String SELECT_FOR_LOCK = "SELECT * FROM {0}LOCKS WHERE SCHED_NAME = {1} AND LOCK_NAME = ? FOR UPDATE";
    public static final String INSERT_LOCK = "INSERT INTO {0}LOCKS(SCHED_NAME, LOCK_NAME) VALUES ({1}, ?)";

    public StdRowLockSemaphore(String tablePrefix, String schedName, String selectWithLockSQL) {
        super(tablePrefix, schedName, selectWithLockSQL != null ? selectWithLockSQL : SELECT_FOR_LOCK, INSERT_LOCK);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeSQL(Connection conn, String lockName, String expandedSQL, String expandedInsertSQL) throws LockException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        do {
            Exception ignore3;
            Object var11_13;
            block24: {
                block25: {
                    ++count;
                    ps = conn.prepareStatement(expandedSQL);
                    ps.setString(1, lockName);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName());
                    }
                    if ((rs = ps.executeQuery()).next()) break block24;
                    this.getLog().debug("Inserting new lock row for lock: '" + lockName + "' being obtained by thread: " + Thread.currentThread().getName());
                    rs.close();
                    rs = null;
                    ps.close();
                    ps = null;
                    ps = conn.prepareStatement(expandedInsertSQL);
                    ps.setString(1, lockName);
                    int res = ps.executeUpdate();
                    if (res == 1) break block24;
                    if (count >= 3) throw new SQLException(Util.rtp("No row exists, and one could not be inserted in table {0}LOCKS for lock named: " + lockName, this.getTablePrefix(), this.getSchedulerNameLiteral()));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore2) {
                        Thread.currentThread().interrupt();
                    }
                    var11_13 = null;
                    if (rs == null) break block25;
                    try {
                        rs.close();
                    }
                    catch (Exception ignore3) {
                        // empty catch block
                    }
                }
                if (ps == null) continue;
                try {
                    ps.close();
                }
                catch (Exception ignore3) {}
                continue;
            }
            var11_13 = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ignore3) {
                    // empty catch block
                }
            }
            if (ps == null) return;
            try {
                ps.close();
                return;
            }
            catch (Exception ignore3) {}
            return;
            {
                catch (SQLException sqle) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName() + (count < 3 ? " - will try again." : ""));
                    }
                    if (count >= 3) throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore4) {
                        Thread.currentThread().interrupt();
                    }
                    var11_13 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ignore3) {
                            // empty catch block
                        }
                    }
                    if (ps == null) continue;
                    try {
                        ps.close();
                    }
                    catch (Exception ignore3) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_13 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception ignore3) {
                        // empty catch block
                    }
                }
                if (ps == null) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (Exception ignore3) {
                    // empty catch block
                }
                throw throwable;
            }
        } while (count < 2);
    }

    protected String getSelectWithLockSQL() {
        return this.getSQL();
    }

    public void setSelectWithLockSQL(String selectWithLockSQL) {
        this.setSQL(selectWithLockSQL);
    }
}

