/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;

public class VerifyRequest
extends AuthSuccess {
    private static Log _log = LogFactory.getLog(VerifyRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String MODE_CHKAUTH = "check_authentication";

    protected VerifyRequest(AuthSuccess authResp) {
        super(VerifyRequest.convertAuthSuccessParams(authResp));
    }

    private static ParameterList convertAuthSuccessParams(AuthSuccess authResp) {
        ParameterList params = new ParameterList(authResp.getParameterMap());
        params.set(new Parameter("openid.mode", MODE_CHKAUTH));
        return params;
    }

    protected VerifyRequest(ParameterList params) {
        super(params);
    }

    public static VerifyRequest createVerifyRequest(AuthSuccess authResp) throws MessageException {
        VerifyRequest req = new VerifyRequest(authResp);
        req.validate();
        if (DEBUG) {
            _log.debug((Object)("Created verification request from a positive auth response:\n" + req.keyValueFormEncoding()));
        }
        return req;
    }

    public static VerifyRequest createVerifyRequest(ParameterList params) throws MessageException {
        VerifyRequest req = new VerifyRequest(params);
        req.validate();
        if (DEBUG) {
            _log.debug((Object)("Created verification request:\n" + req.keyValueFormEncoding()));
        }
        return req;
    }

    public String getHandle() {
        return this.getParameterValue("openid.assoc_handle");
    }

    public String getInvalidateHandle() {
        return this.getParameterValue("openid.invalidate_handle");
    }

    public void validate() throws MessageException {
        if (!MODE_CHKAUTH.equals(this.getParameterValue("openid.mode"))) {
            throw new MessageException("Invalid openid.mode in verification request: " + this.getParameterValue("openid.mode"), 1024);
        }
        this.set("openid.mode", "id_res");
        if (DEBUG) {
            _log.debug((Object)"Delegating verification request validity check to auth response...");
        }
        super.validate();
        this.set("openid.mode", MODE_CHKAUTH);
    }
}

