/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usergroupsadmin.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupLocalServiceUtil;

public class UserGroupStagedModelDataHandler
extends BaseStagedModelDataHandler<UserGroup> {
    public static final String[] CLASS_NAMES = new String[]{UserGroup.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        UserGroup userGroup = UserGroupLocalServiceUtil.fetchUserGroupByUuidAndCompanyId((String)uuid, (long)group.getCompanyId());
        if (userGroup != null) {
            UserGroupLocalServiceUtil.deleteUserGroup((UserGroup)userGroup);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(UserGroup userGroup) {
        return userGroup.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, UserGroup userGroup) throws Exception {
        Element userGroupElement = portletDataContext.getExportDataElement((ClassedModel)userGroup);
        portletDataContext.addClassedModel(userGroupElement, ExportImportPathUtil.getModelPath((StagedModel)userGroup), (ClassedModel)userGroup);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, UserGroup userGroup) throws Exception {
        long userId = portletDataContext.getUserId(userGroup.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)userGroup);
        UserGroup existingUserGroup = UserGroupLocalServiceUtil.fetchUserGroupByUuidAndCompanyId((String)userGroup.getUuid(), (long)portletDataContext.getCompanyId());
        if (existingUserGroup == null) {
            existingUserGroup = UserGroupLocalServiceUtil.fetchUserGroup((long)portletDataContext.getCompanyId(), (String)userGroup.getName());
        }
        UserGroup importedUserGroup = null;
        if (existingUserGroup == null) {
            serviceContext.setUuid(userGroup.getUuid());
            importedUserGroup = UserGroupLocalServiceUtil.addUserGroup((long)userId, (long)portletDataContext.getCompanyId(), (String)userGroup.getName(), (String)userGroup.getDescription(), (ServiceContext)serviceContext);
        } else {
            importedUserGroup = UserGroupLocalServiceUtil.updateUserGroup((long)portletDataContext.getCompanyId(), (long)existingUserGroup.getUserGroupId(), (String)userGroup.getName(), (String)userGroup.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)userGroup, (ClassedModel)importedUserGroup);
    }
}

