/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.action;

import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.polls.DuplicateVoteException;
import com.liferay.portlet.polls.NoSuchChoiceException;
import com.liferay.portlet.polls.NoSuchQuestionException;
import com.liferay.portlet.polls.QuestionChoiceException;
import com.liferay.portlet.polls.QuestionDescriptionException;
import com.liferay.portlet.polls.QuestionExpirationDateException;
import com.liferay.portlet.polls.QuestionExpiredException;
import com.liferay.portlet.polls.QuestionTitleException;
import com.liferay.portlet.polls.action.ActionUtil;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.service.PollsQuestionServiceUtil;
import com.liferay.portlet.polls.service.persistence.PollsChoiceUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditQuestionAction
extends PortletAction {
    public static final String CHOICE_DESCRIPTION_PREFIX = "choiceDescription";
    public static final String CHOICE_NAME_PREFIX = "choiceName";

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        block11: {
            String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
            try {
                if (Validator.isNull((String)cmd)) {
                    return;
                }
                if (cmd.equals("add") || cmd.equals("update") || cmd.equals("vote")) {
                    this.updateQuestion(portletConfig, actionRequest, actionResponse);
                } else if (cmd.equals("delete")) {
                    this.deleteQuestion(actionRequest);
                }
                WindowState windowState = actionRequest.getWindowState();
                if (windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                    if (Validator.isNotNull((String)redirect)) {
                        actionResponse.sendRedirect(redirect);
                    }
                } else {
                    this.sendRedirect(actionRequest, actionResponse);
                }
            }
            catch (Exception e2) {
                if (e2 instanceof NoSuchQuestionException || e2 instanceof PrincipalException) {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                    this.setForward((PortletRequest)actionRequest, "portlet.polls.error");
                }
                if (e2 instanceof DuplicateVoteException || e2 instanceof NoSuchChoiceException || e2 instanceof QuestionChoiceException || e2 instanceof QuestionDescriptionException || e2 instanceof QuestionExpirationDateException || e2 instanceof QuestionTitleException) {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                    SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".hideDefaultErrorMessage"));
                }
                if (e2 instanceof QuestionExpiredException) break block11;
                throw e2;
            }
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getQuestion((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchQuestionException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.polls.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.polls.edit_question"));
    }

    protected void addAndStoreSelection(PortletRequest portletRequest, PollsQuestion question) throws Exception {
        String referringPortletResource = ParamUtil.getString((PortletRequest)portletRequest, (String)"referringPortletResource");
        if (Validator.isNull((String)referringPortletResource)) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)themeDisplay.getRefererPlid());
        PortletPreferences portletPreferences = this.getStrictPortletSetup(layout, referringPortletResource);
        portletPreferences.setValue("questionId", String.valueOf(question.getQuestionId()));
        portletPreferences.store();
        SessionMessages.add((PortletRequest)portletRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)portletRequest)) + ".refreshPortlet"), (Object)referringPortletResource);
    }

    protected void deleteQuestion(ActionRequest actionRequest) throws Exception {
        long questionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"questionId");
        PollsQuestionServiceUtil.deleteQuestion((long)questionId);
    }

    protected void updateQuestion(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long questionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"questionId");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        int expirationDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateMonth");
        int expirationDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateDay");
        int expirationDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateYear");
        int expirationDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateHour");
        int expirationDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateMinute");
        int expirationDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateAmPm");
        boolean neverExpire = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"neverExpire");
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        ArrayList<PollsChoice> choices = new ArrayList<PollsChoice>();
        HashSet<String> readParameters = new HashSet<String>();
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            if (!param.startsWith(CHOICE_DESCRIPTION_PREFIX)) continue;
            try {
                String id = param.substring(CHOICE_DESCRIPTION_PREFIX.length(), param.indexOf(95));
                if (readParameters.contains(id)) continue;
                String choiceName = ParamUtil.getString((PortletRequest)actionRequest, (String)(CHOICE_NAME_PREFIX + id));
                Map localeChoiceDescriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)(CHOICE_DESCRIPTION_PREFIX + id));
                PollsChoice choice = PollsChoiceUtil.create((long)0L);
                choice.setName(choiceName);
                choice.setDescriptionMap(localeChoiceDescriptionMap);
                choices.add(choice);
                readParameters.add(id);
            }
            catch (Exception exception) {}
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BookmarksEntry.class.getName(), (PortletRequest)actionRequest);
        if (questionId <= 0L) {
            PollsQuestion question = PollsQuestionServiceUtil.addQuestion((Map)titleMap, (Map)descriptionMap, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, choices, (ServiceContext)serviceContext);
            this.addAndStoreSelection((PortletRequest)actionRequest, question);
        } else {
            PollsQuestionServiceUtil.updateQuestion((long)questionId, (Map)titleMap, (Map)descriptionMap, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, choices, (ServiceContext)serviceContext);
        }
    }
}

