/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.model.DDMStorageLink;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMStorageLinkLocalServiceBaseImpl;
import java.util.List;

public class DDMStorageLinkLocalServiceImpl
extends DDMStorageLinkLocalServiceBaseImpl {
    public DDMStorageLink addStorageLink(long classNameId, long classPK, long structureId, ServiceContext serviceContext) throws SystemException {
        long storageLinkId = this.counterLocalService.increment();
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.create(storageLinkId);
        storageLink.setClassNameId(classNameId);
        storageLink.setClassPK(classPK);
        storageLink.setStructureId(structureId);
        this.ddmStorageLinkPersistence.update((BaseModel)storageLink);
        return storageLink;
    }

    public void deleteClassStorageLink(long classPK) throws PortalException, SystemException {
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.findByClassPK(classPK);
        this.deleteStorageLink(storageLink);
    }

    public void deleteStorageLink(DDMStorageLink storageLink) throws SystemException {
        this.ddmStorageLinkPersistence.remove((BaseModel)storageLink);
    }

    public void deleteStorageLink(long storageLinkId) throws PortalException, SystemException {
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.findByPrimaryKey(storageLinkId);
        this.deleteStorageLink(storageLink);
    }

    public void deleteStructureStorageLinks(long structureId) throws SystemException {
        List storageLinks = this.ddmStorageLinkPersistence.findByStructureId(structureId);
        for (DDMStorageLink storageLink : storageLinks) {
            this.deleteStorageLink(storageLink);
        }
    }

    public DDMStorageLink getClassStorageLink(long classPK) throws PortalException, SystemException {
        return this.ddmStorageLinkPersistence.findByClassPK(classPK);
    }

    public DDMStorageLink getStorageLink(long storageLinkId) throws PortalException, SystemException {
        return this.ddmStorageLinkPersistence.findByPrimaryKey(storageLinkId);
    }

    public List<DDMStorageLink> getStructureStorageLinks(long structureId) throws SystemException {
        return this.ddmStorageLinkPersistence.findByStructureId(structureId);
    }

    public int getStructureStorageLinksCount(long structureId) throws SystemException {
        return this.ddmStorageLinkPersistence.countByStructureId(structureId);
    }

    public DDMStorageLink updateStorageLink(long storageLinkId, long classNameId, long classPK) throws PortalException, SystemException {
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.findByPrimaryKey(storageLinkId);
        storageLink.setClassNameId(classNameId);
        storageLink.setClassPK(classPK);
        this.ddmStorageLinkPersistence.update((BaseModel)storageLink);
        return storageLink;
    }
}

