/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.oidc.rest.OpenIdConnectRESTHelperException;
import org.gcube.portal.oidc.lr62.InvalidTokenException;
import org.gcube.portal.oidc.lr62.JWTCacheProxy;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;
import org.gcube.portal.oidc.lr62.MissingTokenException;
import org.gcube.portal.oidc.lr62.NotAuthorizedException;
import org.gcube.portal.oidc.lr62.RefreshException;
import org.gcube.portal.oidc.lr62.UMAException;
import org.gcube.portal.oidc.lr62.UMATokensProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCUmaUtil {
    private static final Logger log = LoggerFactory.getLogger(OIDCUmaUtil.class);
    private static final boolean REFRESH_UMA_TOKEN = false;
    private static final String LOGOUT_URI = "/c/portal/logout";
    private static final boolean FORCE_LOGOUT_ON_INVALID_TOKEN = true;
    private static final boolean FORCE_LOGOUT_ON_MISSING_OIDC = true;
    private static final boolean FORCE_LOGOUT_ON_OIDC_REFRESH_ERROR = true;
    private static final int MAX_AUTHORIZATION_RETRY_ATTEMPTS = 4;
    private static final int AUTHORIZATION_RETRY_ATTEMPTS_DELAY = 4000;

    public static void provideConfiguredPortalClientUMATokenInThreadLocal(String infraContext) {
        LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration();
        String clientId = configuration.getPortalClientId();
        String clientSecret = configuration.getPortalClientSecret();
        OIDCUmaUtil.provideClientUMATokenInThreadLocal(clientId, clientSecret, configuration.getTokenURL(), infraContext);
    }

    public static void provideClientUMATokenInThreadLocal(String clientId, String clientSecret, URL tokenURL, String infraContext) {
        try {
            log.debug("Getting client token from server");
            JWTToken clientToken = OpenIdConnectRESTHelper.queryClientToken((String)clientId, (String)clientSecret, (URL)tokenURL);
            OIDCUmaUtil.provideClientUMATokenInThreadLocal(clientToken.getAccessTokenAsBearer(), tokenURL, infraContext);
        }
        catch (Exception e) {
            log.error("Cannot retrieve client OIDC token", (Throwable)e);
            return;
        }
    }

    public static void provideClientUMATokenInThreadLocal(String clientAuthorizationBearer, URL tokenURL, String infraContext) {
        String encodedContext;
        try {
            encodedContext = URLEncoder.encode(infraContext, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Cannot URL encode context", (Throwable)e);
            return;
        }
        log.debug("URL encoded context is: {}", (Object)encodedContext);
        try {
            log.debug("Getting UMA token from server");
            JWTToken umaToken = OpenIdConnectRESTHelper.queryUMAToken((URL)tokenURL, (String)clientAuthorizationBearer, (String)encodedContext, null);
            OIDCUmaUtil.provideTokensInThreadlocal(umaToken);
        }
        catch (Exception e) {
            log.error("Cannot retrieve client UMA token", (Throwable)e);
            return;
        }
    }

    public static JWTToken getUMAToken(HttpServletRequest request, Long userId, String scope) throws UMAException, InvalidTokenException, MissingTokenException, RefreshException, NotAuthorizedException {
        return OIDCUmaUtil.getUMAToken(request, userId, scope, true);
    }

    private static JWTToken getUMAToken(HttpServletRequest request, Long userId, String scope, boolean temporary) throws UMAException, InvalidTokenException, MissingTokenException, RefreshException, NotAuthorizedException {
        try {
            return OIDCUmaUtil.getUMAToken(request, UserLocalServiceUtil.getUser((long)userId), scope, temporary);
        }
        catch (PortalException | SystemException e) {
            throw new UMAException("Cannot get liferay user from userId", e);
        }
    }

    public static JWTToken getUMAToken(HttpServletRequest request, String screenName, String scope) throws UMAException, InvalidTokenException, MissingTokenException, RefreshException, NotAuthorizedException {
        return OIDCUmaUtil.getUMAToken(request, screenName, scope, true);
    }

    private static JWTToken getUMAToken(HttpServletRequest request, String screenName, String scope, boolean temporary) throws UMAException, InvalidTokenException, MissingTokenException, RefreshException, NotAuthorizedException {
        try {
            return OIDCUmaUtil.getUMAToken(request, UserLocalServiceUtil.getUserByScreenName((long)PortalUtil.getCompanyId((HttpServletRequest)request), (String)screenName), scope, temporary);
        }
        catch (PortalException | SystemException e) {
            throw new UMAException("Cannot get liferay user from companyId and screenName", e);
        }
    }

    public static JWTToken getUMAToken(HttpServletRequest request, User user, String scope) throws InvalidTokenException, MissingTokenException, RefreshException, NotAuthorizedException, UMAException {
        return OIDCUmaUtil.getUMAToken(request, user, scope, true);
    }

    private static JWTToken getUMAToken(HttpServletRequest request, User user, String scope, boolean temporary) throws InvalidTokenException, MissingTokenException, RefreshException, NotAuthorizedException, UMAException {
        return OIDCUmaUtil.getUMAToken(request, user, request.getSession(false), scope, temporary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JWTToken getUMAToken(HttpServletRequest request, User user, HttpSession session, String scope, boolean temporary) throws InvalidTokenException, MissingTokenException, RefreshException, NotAuthorizedException, UMAException {
        if (user == null) {
            log.error("User is null, cannot continue");
            return null;
        }
        log.debug("Current user is: {} [{}]", (Object)user.getScreenName(), (Object)user.getEmailAddress());
        if (session == null) {
            log.debug("Session is null, cannot continue");
            throw new UMAException("Session is null");
        }
        String sessionId = session.getId();
        log.debug("Current session ID is {}", (Object)sessionId);
        String urlEncodedScope = null;
        try {
            urlEncodedScope = URLEncoder.encode(scope, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Cannot URL encode scope", (Throwable)e);
            return null;
        }
        log.debug("URL encoded scope is: {}", (Object)urlEncodedScope);
        JWTToken umaToken = null;
        JWTCacheProxy jwtCacheProxy = JWTCacheProxy.getInstance();
        Map<String, String> map = jwtCacheProxy.getMutexFor(user);
        synchronized (map) {
            log.trace("Getting UMA token for user {}, and session {}", (Object)user.getScreenName(), (Object)sessionId);
            umaToken = jwtCacheProxy.getUMAToken(user, sessionId);
            if (umaToken != null && !umaToken.isExpired() && umaToken.getAud().contains(urlEncodedScope)) {
                log.trace("Current UMA token is OK {}", (Object)umaToken.getTokenEssentials());
            } else {
                if (umaToken != null && umaToken.getAud().contains(urlEncodedScope) && umaToken.isExpired()) {
                    log.debug("Suitable UMA token found but it is expired.It will be replaced with new one according to settings {}", (Object)umaToken.getTokenEssentials());
                    umaToken = null;
                    log.debug("Removing inactive UMA token from cache proxy if present for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                    jwtCacheProxy.removeUMAToken(user, sessionId);
                }
                if (umaToken == null || !umaToken.getAud().contains(urlEncodedScope)) {
                    boolean scopeIsChanged = false;
                    if (umaToken == null) {
                        log.debug("Getting new UMA token for scope {}", (Object)urlEncodedScope);
                    } else if (!umaToken.getAud().contains(urlEncodedScope)) {
                        scopeIsChanged = true;
                        log.info("Getting new UMA token for scope {} since it has been issued for another scope {}", (Object)urlEncodedScope, (Object)umaToken.getTokenEssentials());
                    }
                    log.debug("Getting OIDC token from cache proxy for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                    JWTToken authToken = jwtCacheProxy.getOIDCToken(user, sessionId);
                    if (authToken == null) {
                        throw new MissingTokenException("Token is null in proxy");
                    }
                    log.debug("OIDC token is {}", (Object)authToken.getTokenEssentials());
                    LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration(request);
                    boolean isNotAuthorized = false;
                    int authorizationAttempts = 0;
                    do {
                        try {
                            if (isNotAuthorized || scopeIsChanged || authToken.isExpired()) {
                                if (isNotAuthorized) {
                                    log.info("UMA token is not authorized with current OIDC token, refreshing it to be sure that new grants are present. [attempts: {}]", (Object)authorizationAttempts);
                                    isNotAuthorized = false;
                                } else if (scopeIsChanged) {
                                    log.info("Scope is changed, refreshing token to be sure that new grants are present");
                                } else if (authToken.isExpired()) {
                                    log.debug("OIDC token is expired, trying to refresh it {}", (Object)authToken.getTokenEssentials());
                                }
                                try {
                                    authToken = OpenIdConnectRESTHelper.refreshToken((URL)configuration.getTokenURL(), (JWTToken)authToken);
                                }
                                catch (OpenIdConnectRESTHelperException e) {
                                    throw new RefreshException("Refreshing OIDC token", e);
                                }
                                log.debug("Setting refreshed OIDC token in cache proxy");
                                jwtCacheProxy.setOIDCToken(user, sessionId, authToken);
                            }
                            log.info("Getting UMA token from OIDC endpoint for scope: " + urlEncodedScope);
                            umaToken = OpenIdConnectRESTHelper.queryUMAToken((URL)configuration.getTokenURL(), (String)authToken.getAccessTokenAsBearer(), (String)urlEncodedScope, null);
                            log.debug("Got new UMA token {}", (Object)umaToken.getTokenEssentials());
                        }
                        catch (OpenIdConnectRESTHelperException e) {
                            if (e.hasJSONPayload()) {
                                if (OpenIdConnectRESTHelper.isInvalidBearerTokenError((String)e.getResponseString())) {
                                    throw new InvalidTokenException("OIDC token is become invalid", e);
                                }
                                if (!OpenIdConnectRESTHelper.isAccessDeniedNotAuthorizedError((String)e.getResponseString())) continue;
                                log.info("UMA token is" + (isNotAuthorized ? " still" : "") + " not authorized with actual OIDC token");
                                isNotAuthorized = true;
                                if (++authorizationAttempts <= 4) {
                                    log.debug("Sleeping 4000 ms and looping refreshing the OIDC");
                                    try {
                                        Thread.sleep(4000L);
                                    }
                                    catch (InterruptedException ie) {
                                        ie.printStackTrace();
                                    }
                                    continue;
                                }
                                throw new NotAuthorizedException("OIDC token refresh attempts exhausted");
                            }
                            throw new UMAException(e);
                        }
                    } while (isNotAuthorized);
                }
                if (!temporary) {
                    log.debug("Setting UMA token in cache proxy for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                    jwtCacheProxy.setUMAToken(user, sessionId, umaToken);
                }
            }
        }
        return umaToken;
    }

    public static void checkUMATicketAndProvideInThreadLocal(HttpServletRequest request, HttpServletResponse response, User user, HttpSession session, String scope) {
        try {
            JWTToken umaToken = OIDCUmaUtil.getUMAToken(request, user, session, scope, false);
            log.trace("Current UMA token in use is: {}", (Object)umaToken.getTokenEssentials());
            OIDCUmaUtil.provideTokensInThreadlocal(umaToken);
        }
        catch (MissingTokenException e) {
            log.debug("OIDC token is null in cache proxy, force redirecting to logut URI");
            OIDCUmaUtil.forceLogout(response);
            return;
        }
        catch (RefreshException e) {
            log.warn("Error refreshing OIDC token, force redirecting to logut URI");
            OIDCUmaUtil.forceLogout(response);
            return;
        }
        catch (InvalidTokenException e) {
            log.warn("OIDC token is become invalid, forcing redirect to logout URI");
            OIDCUmaUtil.forceLogout(response);
            return;
        }
        catch (NotAuthorizedException e) {
            log.error("", (Throwable)e);
        }
        catch (UMAException e) {
            log.error("Getting UMA token from server", (Throwable)e);
        }
    }

    public static void provideTokensInThreadlocal(JWTToken umaTokens) {
        log.debug("Setting UMA token with jti {} in UMA providers", (Object)umaTokens.getJti());
        UMATokensProvider.instance.set(JWTTokenUtil.getRawContent(umaTokens));
        AccessTokenProvider.instance.set(JWTTokenUtil.getAccessTokenString(umaTokens));
    }

    protected static void forceLogout(HttpServletResponse response) {
        try {
            if (!response.isCommitted()) {
                response.sendRedirect(LOGOUT_URI);
            } else {
                log.warn("Cannot redirect to logout URI since the response is already commited");
            }
        }
        catch (IOException e) {
            log.error("Cannot redirect to logout URI: /c/portal/logout", (Throwable)e);
        }
    }
}

