/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ccpp;

import com.sun.ccpp.ComponentDescriptionImpl;
import com.sun.ccpp.DescriptionManager;
import com.sun.ccpp.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.ccpp.AttributeDescription;
import javax.ccpp.ComponentDescription;
import javax.ccpp.ProfileDescription;

public class ProfileDescriptionImpl
implements ProfileDescription,
Cloneable {
    private Logger logger = Log.getLogger();
    private HashMap attributes = new HashMap();
    private HashMap components = new HashMap();
    private URI uri = null;

    ProfileDescriptionImpl() {
    }

    void mergeProfileDescription(ProfileDescription other) {
        Set otherComps = other.getComponentDescriptions();
        Iterator i = otherComps.iterator();
        while (i.hasNext()) {
            ComponentDescriptionImpl otherComp = (ComponentDescriptionImpl)i.next();
            String localType = otherComp.getLocalType();
            ComponentDescriptionImpl thisComp = (ComponentDescriptionImpl)this.getComponentDescription(localType);
            if (thisComp == null) {
                thisComp = (ComponentDescriptionImpl)otherComp.clone();
                try {
                    URI newURI = new URI(this.getURI().toString() + localType);
                    thisComp.setURI(newURI);
                }
                catch (URISyntaxException e) {
                    this.logger.info("Invalid URI for component. " + e.getMessage());
                }
                this.addComponentDescription(thisComp);
                DescriptionManager.getInstance().addComponentDescription(thisComp);
            }
            thisComp.mergeComponentDescription(otherComp);
        }
    }

    void addComponentDescription(ComponentDescription comp) {
        if (comp == null) {
            return;
        }
        this.components.put(comp.getLocalType(), comp);
        this.addAttributeDescriptions(comp);
    }

    private void addAttributeDescriptions(ComponentDescription comp) {
        if (comp == null) {
            return;
        }
        Set attrs = comp.getAttributeDescriptions();
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            AttributeDescription attr = (AttributeDescription)i.next();
            this.attributes.put(attr.getName(), attr);
        }
    }

    void setURI(URI uri) {
        this.uri = uri;
    }

    public Object clone() {
        ProfileDescriptionImpl clone = new ProfileDescriptionImpl();
        clone.attributes.putAll(this.attributes);
        clone.components.putAll(this.components);
        clone.setURI(this.uri);
        return clone;
    }

    public AttributeDescription getAttributeDescription(String name) {
        return (AttributeDescription)this.attributes.get(name);
    }

    public Set getAttributeDescriptionNames() {
        return this.attributes.keySet();
    }

    public Set getAttributeDescriptions() {
        return new HashSet(this.attributes.values());
    }

    public ComponentDescription getComponentDescription(String type) {
        return (ComponentDescription)this.components.get(type);
    }

    public Set getComponentDescriptions() {
        return new HashSet(this.components.values());
    }

    public Set getComponentTypes() {
        return this.components.keySet();
    }

    public String getURI() {
        return this.uri.toString();
    }

    URI getURIObject() {
        return this.uri;
    }
}

