/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.collect.Lists;
import com.netflix.astyanax.connectionpool.Connection;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NoAvailableHostsException;
import com.netflix.astyanax.connectionpool.impl.AbstractExecuteWithFailoverImpl;
import java.util.Iterator;
import java.util.List;

public class LeastOutstandingExecuteWithFailover<CL, R>
extends AbstractExecuteWithFailoverImpl<CL, R> {
    protected HostConnectionPool<CL> pool;
    private int retryCountdown;
    protected final List<HostConnectionPool<CL>> pools;
    protected int waitDelta;
    protected int waitMultiplier = 1;

    public LeastOutstandingExecuteWithFailover(ConnectionPoolConfiguration config, ConnectionPoolMonitor monitor, List<HostConnectionPool<CL>> pools) throws ConnectionException {
        super(config, monitor);
        this.pools = Lists.newArrayList(pools);
        if (this.pools == null || this.pools.isEmpty()) {
            throw new NoAvailableHostsException("No hosts to borrow from");
        }
        int size = this.pools.size();
        this.retryCountdown = Math.min(config.getMaxFailoverCount(), size);
        if (this.retryCountdown < 0) {
            this.retryCountdown = size;
        } else if (this.retryCountdown == 0) {
            this.retryCountdown = 1;
        }
        this.waitDelta = config.getMaxTimeoutWhenExhausted() / this.retryCountdown;
    }

    @Override
    public boolean canRetry() {
        return --this.retryCountdown > 0;
    }

    @Override
    public HostConnectionPool<CL> getCurrentHostConnectionPool() {
        return this.pool;
    }

    @Override
    public Connection<CL> borrowConnection(Operation<CL, R> operation) throws ConnectionException {
        Iterator<HostConnectionPool<CL>> iterator = this.pools.iterator();
        HostConnectionPool<CL> eligible = iterator.next();
        while (iterator.hasNext()) {
            HostConnectionPool<CL> candidate = iterator.next();
            if (candidate.getIdleConnectionCount() <= eligible.getIdleConnectionCount()) continue;
            eligible = candidate;
        }
        return eligible.borrowConnection(this.waitDelta * this.waitMultiplier);
    }
}

