/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Comparator;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementDMQL;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class StatementSet
extends StatementDMQL {
    Expression expression;
    Expression[] targets;
    int[] variableIndexes;
    Type[] sourceTypes;
    final int operationType;
    public static final int TRIGGER_SET = 1;
    public static final int SELECT_INTO = 2;
    public static final int VARIABLE_SET = 3;

    StatementSet(Session session, Expression[] targets, Table table, RangeVariable[] rangeVars, int[] indexes, Expression[] colExpressions, ParserDQL.CompileContext compileContext) {
        super(5, 2004, session.getCurrentSchemaHsqlName());
        this.operationType = 1;
        this.targets = targets;
        this.targetTable = table;
        this.baseTable = this.targetTable.getBaseTable();
        this.updateColumnMap = indexes;
        this.updateExpressions = colExpressions;
        this.updateCheckColumns = this.targetTable.getColumnCheckList(indexes);
        this.targetRangeVariables = rangeVars;
        this.isTransactionStatement = false;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    StatementSet(Session session, Expression[] targets, Expression e, int[] indexes, ParserDQL.CompileContext compileContext) {
        super(5, 2007, null);
        this.operationType = 3;
        this.targets = targets;
        this.expression = e;
        this.variableIndexes = indexes;
        this.sourceTypes = this.expression.getNodeDataTypes();
        this.isTransactionStatement = false;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    StatementSet(Session session, Expression[] targets, QueryExpression query, int[] indexes, ParserDQL.CompileContext compileContext) {
        super(5, 2007, null);
        this.operationType = 2;
        this.queryExpression = query;
        this.targets = targets;
        this.variableIndexes = indexes;
        this.sourceTypes = query.getColumnTypes();
        this.isTransactionStatement = false;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    SubQuery[] getSubqueries(Session session) {
        BaseHashMap subQueries = null;
        if (this.expression != null) {
            subQueries = this.expression.collectAllSubqueries((OrderedHashSet)subQueries);
        }
        if (subQueries == null || subQueries.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] subQueryArray = new SubQuery[subQueries.size()];
        ((HashSet)subQueries).toArray(subQueryArray);
        ArraySort.sort(subQueryArray, 0, subQueryArray.length, (Comparator)subQueryArray[0]);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((SubQuery)subQueryArray[i]).prepareTable(session);
        }
        return subQueryArray;
    }

    Result getResult(Session session) {
        Result result = null;
        switch (this.operationType) {
            case 1: {
                result = this.executeTriggerSetStatement(session);
                break;
            }
            case 2: {
                Object[] values = this.queryExpression.getSingleRowValues(session);
                if (values == null) {
                    result = Result.updateZeroResult;
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.targets[i].getColumn().getDataType().convertToType(session, values[i], this.sourceTypes[i]);
                }
                result = this.executeAssignment(session, values);
                break;
            }
            case 3: {
                Object[] values = this.getExpressionValues(session);
                if (values == null) {
                    result = Result.updateZeroResult;
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    Type targetType = this.targets[i].getType() == 99 ? this.targets[i].getLeftNode().getColumn().getDataType().collectionBaseType() : this.targets[i].getColumn().getDataType();
                    values[i] = targetType.convertToType(session, values[i], this.sourceTypes[i]);
                }
                result = this.executeAssignment(session, values);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSet");
            }
        }
        return result;
    }

    public void resolve(Session session) {
        this.references = new OrderedHashSet();
        switch (this.operationType) {
            case 1: {
                for (int i = 0; i < this.updateExpressions.length; ++i) {
                    this.updateExpressions[i].collectObjectNames(this.references);
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.expression != null) {
                    this.expression.collectObjectNames(this.references);
                }
                if (this.queryExpression == null) break;
                this.queryExpression.collectObjectNames(this.references);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSet");
            }
        }
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.operationType) {
            case 1: {
                return this.sql;
            }
            case 3: {
                sb.append("SET").append(' ');
                sb.append(this.targets[0].getColumn().getName().statementName);
                sb.append(' ').append('=').append(' ').append(this.expression.getSQL());
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    public String describe(Session session) {
        return "";
    }

    Result executeTriggerSetStatement(Session session) {
        Table table = this.targetTable;
        int[] colMap = this.updateColumnMap;
        Expression[] colExpressions = this.updateExpressions;
        Type[] colTypes = table.getColumnTypes();
        int index = this.targetRangeVariables[1].rangePosition;
        Object[] oldData = session.sessionContext.triggerArguments[index];
        Object[] data = StatementDML.getUpdatedData(session, this.targets, table, colMap, colExpressions, colTypes, oldData);
        ArrayUtil.copyArray(data, oldData, data.length);
        return Result.updateOneResult;
    }

    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName name = rangeTable.getName();
            if (rangeTable.isReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            set.add(name);
        }
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    void collectTableNamesForWrite(OrderedHashSet set) {
    }

    Object[] getExpressionValues(Session session) {
        Object[] values;
        if (this.expression.getType() == 25) {
            values = this.expression.getRowValue(session);
        } else if (this.expression.getType() == 22) {
            values = this.expression.subQuery.queryExpression.getSingleRowValues(session);
            if (values == null) {
                return null;
            }
        } else {
            values = new Object[]{this.expression.getValue(session)};
        }
        return values;
    }

    Result executeAssignment(Session session, Object[] values) {
        for (int j = 0; j < values.length; ++j) {
            Object[] data = ValuePool.emptyObjectArray;
            switch (this.targets[j].getColumn().getType()) {
                case 23: {
                    data = session.sessionContext.routineArguments;
                    break;
                }
                case 22: {
                    data = session.sessionContext.routineVariables;
                }
            }
            int colIndex = this.variableIndexes[j];
            data[colIndex] = this.targets[j].getType() == 99 ? ((ExpressionAccessor)this.targets[j]).getUpdatedArray(session, (Object[])data[colIndex], values[j], true) : values[j];
        }
        return Result.updateZeroResult;
    }
}

