/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.User;

public class UserFirstNameComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "firstName ASC, middleName ASC, lastName ASC";
    public static final String ORDER_BY_DESC = "firstName DESC, middleName DESC, lastName DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"firstName", "middleName", "lastName"};
    private boolean _ascending;

    public UserFirstNameComparator() {
        this(false);
    }

    public UserFirstNameComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        String firstName2;
        User user1 = (User)obj1;
        User user2 = (User)obj2;
        String firstName1 = user1.getFirstName();
        int value = firstName1.compareTo(firstName2 = user2.getFirstName());
        if (value == 0) {
            String middleName1 = user1.getMiddleName();
            String middleName2 = user2.getMiddleName();
            value = middleName1.compareTo(middleName2);
        }
        if (value == 0) {
            String lastName1 = user1.getLastName();
            String lastName2 = user2.getLastName();
            value = lastName1.compareTo(lastName2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

