/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.test;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.cassandra.service.CassandraDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedCassandra {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedCassandra.class);
    public static final int DEFAULT_PORT = 9160;
    public static final int DEFAULT_STORAGE_PORT = 7000;
    private final ExecutorService service = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EmbeddedCassandra-%d").build());
    private final CassandraDaemon cassandra;
    private final File dataDir;

    public EmbeddedCassandra() throws IOException {
        this(EmbeddedCassandra.createTempDir(), "TestCluster", 9160, 7000);
    }

    public EmbeddedCassandra(String dataDir) throws IOException {
        this(new File(dataDir), "TestCluster", 9160, 7000);
    }

    public EmbeddedCassandra(File dataDir) throws IOException {
        this(dataDir, "TestCluster", 9160, 7000);
    }

    private static File createTempDir() {
        File tempDir = Files.createTempDir();
        tempDir.deleteOnExit();
        return tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbeddedCassandra(File dataDir, String clusterName, int port, int storagePort) throws IOException {
        LOG.info("Starting cassandra in dir " + dataDir);
        this.dataDir = dataDir;
        dataDir.mkdirs();
        Closeable is = null;
        try {
            URL templateUrl = EmbeddedCassandra.class.getClassLoader().getResource("cassandra-template.yaml");
            Preconditions.checkNotNull((Object)templateUrl, (Object)"Cassandra config template is null");
            String baseFile = Resources.toString((URL)templateUrl, (Charset)Charset.defaultCharset());
            String newFile = baseFile.replace("$DIR$", dataDir.getPath());
            newFile = newFile.replace("$PORT$", Integer.toString(port));
            newFile = newFile.replace("$STORAGE_PORT$", Integer.toString(storagePort));
            newFile = newFile.replace("$CLUSTER$", clusterName);
            File configFile = new File(dataDir, "cassandra.yaml");
            Files.write((CharSequence)newFile, (File)configFile, (Charset)Charset.defaultCharset());
            LOG.info("Cassandra config file: " + configFile.getPath());
            System.setProperty("cassandra.config", "file:" + configFile.getPath());
            try {
                this.cassandra = new CassandraDaemon();
                this.cassandra.init(null);
            }
            catch (IOException e) {
                LOG.error("Error initializing embedded cassandra", (Throwable)e);
                throw e;
            }
        }
        finally {
            Closeables.close(is, (boolean)true);
        }
        LOG.info("Started cassandra deamon");
    }

    public void start() {
        this.service.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    EmbeddedCassandra.this.cassandra.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void stop() {
        this.service.shutdownNow();
        this.cassandra.deactivate();
    }
}

