/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memcached;

import com.liferay.portal.cache.memcached.MemcachedClientFactory;
import com.liferay.portal.cache.memcached.PooledMemcachePortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class PooledMemcachePortalCacheManager<V>
implements PortalCacheManager<String, V> {
    private MemcachedClientFactory _memcachedClientFactory;
    private Map<String, PortalCache<String, V>> _portalCaches = new ConcurrentHashMap<String, PortalCache<String, V>>();
    private int _timeout;
    private TimeUnit _timeoutTimeUnit;

    public void afterPropertiesSet() {
    }

    public void clearAll() {
        this._portalCaches.clear();
    }

    public void destroy() throws Exception {
        for (PortalCache<String, V> portalCache : this._portalCaches.values()) {
            portalCache.destroy();
        }
    }

    public PortalCache<String, V> getCache(String name) {
        return this.getCache(name, false);
    }

    public PortalCache<String, V> getCache(String name, boolean blocking) {
        PortalCache<String, V> portalCache = this._portalCaches.get(name);
        if (portalCache == null) {
            portalCache = new PooledMemcachePortalCache(name, this._memcachedClientFactory, this._timeout, this._timeoutTimeUnit);
            this._portalCaches.put(name, portalCache);
        }
        return portalCache;
    }

    public void reconfigureCaches(URL configurationURL) {
    }

    public void removeCache(String name) {
        this._portalCaches.remove(name);
    }

    public void setMemcachedClientPool(MemcachedClientFactory memcachedClientFactory) {
        this._memcachedClientFactory = memcachedClientFactory;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public void setTimeoutTimeUnit(String timeoutTimeUnit) {
        this._timeoutTimeUnit = TimeUnit.valueOf(timeoutTimeUnit);
    }
}

