/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.net.InetAddress;
import java.util.List;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncTask;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSyncTask
extends SyncTask {
    private static final Logger logger = LoggerFactory.getLogger(RemoteSyncTask.class);

    public RemoteSyncTask(RepairJobDesc desc, TreeResponse r1, TreeResponse r2) {
        super(desc, r1, r2);
    }

    @Override
    protected void startSync(List<Range<Token>> differences) {
        InetAddress local = FBUtilities.getBroadcastAddress();
        SyncRequest request = new SyncRequest(this.desc, local, this.r1.endpoint, this.r2.endpoint, differences);
        String message = String.format("Forwarding streaming repair of %d ranges to %s (to be streamed with %s)", request.ranges.size(), request.src, request.dst);
        logger.info("[repair #{}] {}", (Object)this.desc.sessionId, (Object)message);
        Tracing.traceRepair(message, new Object[0]);
        MessagingService.instance().sendOneWay(request.createMessage(), request.src);
    }

    public void syncComplete(boolean success) {
        if (success) {
            this.set(this.stat);
        } else {
            this.setException(new RepairException(this.desc, String.format("Sync failed between %s and %s", this.r1.endpoint, this.r2.endpoint)));
        }
    }
}

