/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.Environment;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;

public class WikiLinkTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiLinkTag.class.getName());
    protected static final String LINK_CAPTION = "link-caption";

    public String parse(JFlexLexer lexer, String raw, Object ... args) throws ParserException {
        boolean containsNestedLinks = args.length > 0 && StringUtils.equals((String)args[0].toString(), (String)"nested");
        WikiLink wikiLink = JFlexParserUtil.parseWikiLink(lexer.getParserInput(), lexer.getParserOutput(), raw);
        if (wikiLink.getInterwiki() == null && StringUtils.isBlank((String)wikiLink.getDestination()) && StringUtils.isBlank((String)wikiLink.getSection())) {
            return raw;
        }
        if (containsNestedLinks && (wikiLink.getColon() || !wikiLink.getNamespace().getId().equals(6))) {
            int start = raw.indexOf("[[");
            int end = raw.lastIndexOf("]]");
            String content = raw.substring(start + "[[".length(), end);
            return "[[" + JFlexParserUtil.parseFragment(lexer.getParserInput(), lexer.getParserOutput(), content, lexer.getMode()) + "]]";
        }
        raw = this.processLinkMetadata(lexer.getParserInput(), lexer.getParserOutput(), lexer.getMode(), raw, wikiLink);
        if (lexer.getMode() <= 6) {
            return raw;
        }
        if (!wikiLink.getColon() && wikiLink.getNamespace().getId().equals(6)) {
            return lexer.parse(15, raw, new Object[0]);
        }
        try {
            if (wikiLink.getInterwiki() != null) {
                if (!wikiLink.getColon() && !Environment.getBooleanValue("parser-interwiki-links-inline")) {
                    wikiLink.setText(wikiLink.getInterwiki().getInterwikiDisplay());
                    String url = LinkUtil.interwiki(wikiLink);
                    lexer.getParserOutput().addInterwikiLink(url);
                    return "";
                }
                return LinkUtil.interwiki(wikiLink);
            }
            String virtualWiki = lexer.getParserInput().getVirtualWiki();
            if (wikiLink.getVirtualWiki() != null && !StringUtils.equals((String)wikiLink.getVirtualWiki().getName(), (String)virtualWiki)) {
                virtualWiki = wikiLink.getVirtualWiki().getName();
                if (!wikiLink.getColon() && !Environment.getBooleanValue("parser-virtualwiki-links-inline")) {
                    wikiLink.setText(wikiLink.getVirtualWiki().getName() + ":" + wikiLink.getDestination());
                    String url = LinkUtil.buildInternalLinkHtml(lexer.getParserInput().getContext(), virtualWiki, wikiLink, wikiLink.getText(), null, null, false);
                    lexer.getParserOutput().addVirtualWikiLink(url);
                    return "";
                }
            }
            if (StringUtils.isBlank((String)wikiLink.getText()) && !StringUtils.isBlank((String)wikiLink.getDestination())) {
                wikiLink.setText(wikiLink.getDestination());
                if (!StringUtils.isBlank((String)wikiLink.getSection())) {
                    wikiLink.setText(wikiLink.getText() + "#" + Utilities.decodeAndEscapeTopicName(wikiLink.getSection(), true));
                }
            } else if (StringUtils.isBlank((String)wikiLink.getText()) && !StringUtils.isBlank((String)wikiLink.getSection())) {
                wikiLink.setText(Utilities.decodeAndEscapeTopicName("#" + wikiLink.getSection(), true));
            } else {
                lexer.getParserInput().getTempParams().put(LINK_CAPTION, true);
                wikiLink.setText(JFlexParserUtil.parseFragment(lexer.getParserInput(), lexer.getParserOutput(), wikiLink.getText(), lexer.getMode()));
                lexer.getParserInput().getTempParams().remove(LINK_CAPTION);
            }
            if (StringUtils.equals((String)wikiLink.getDestination(), (String)lexer.getParserInput().getTopicName()) && StringUtils.equals((String)virtualWiki, (String)lexer.getParserInput().getVirtualWiki()) && StringUtils.isBlank((String)wikiLink.getSection())) {
                return "<b>" + (StringUtils.isBlank((String)wikiLink.getText()) ? wikiLink.getDestination() : wikiLink.getText()) + "</b>";
            }
            return LinkUtil.buildInternalLinkHtml(lexer.getParserInput().getContext(), virtualWiki, wikiLink, wikiLink.getText(), null, null, false);
        }
        catch (DataAccessException e) {
            logger.error("Failure while parsing link " + raw, e);
            return "";
        }
        catch (ParserException e) {
            logger.error("Failure while parsing link " + raw, e);
            return "";
        }
    }

    private String processLinkMetadata(ParserInput parserInput, ParserOutput parserOutput, int mode, String raw, WikiLink wikiLink) throws ParserException {
        if (wikiLink.getInterwiki() != null || wikiLink.getVirtualWiki() != null && !StringUtils.equals((String)wikiLink.getVirtualWiki().getName(), (String)parserInput.getVirtualWiki())) {
            return raw;
        }
        String result = raw;
        if (!wikiLink.getColon() && wikiLink.getNamespace().getId().equals(14)) {
            String sortKey = wikiLink.getText();
            if (!StringUtils.isBlank((String)sortKey)) {
                sortKey = JFlexParserUtil.parseFragment(parserInput, parserOutput, sortKey, 6);
            }
            parserOutput.addCategory(wikiLink.getDestination(), sortKey);
            if (mode > 3) {
                result = "";
            }
        }
        if (wikiLink.getInterwiki() == null && (wikiLink.getVirtualWiki() == null || StringUtils.equals((String)wikiLink.getVirtualWiki().getName(), (String)parserInput.getVirtualWiki())) && !StringUtils.isBlank((String)wikiLink.getDestination())) {
            parserOutput.addLink(wikiLink.getDestination());
        }
        return result;
    }
}

