/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.webdav;

import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.webdav.DDMWebDavUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.util.ArrayList;
import java.util.List;

public class JournalWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    public int deleteResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return DDMWebDavUtil.deleteResource(webDAVRequest, this.getRootPath(), this.getToken(), PortalUtil.getClassNameId(JournalArticle.class));
    }

    public Resource getResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return DDMWebDavUtil.getResource(webDAVRequest, this.getRootPath(), this.getToken(), PortalUtil.getClassNameId(JournalArticle.class));
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            String[] pathArray = webDAVRequest.getPathArray();
            if (pathArray.length == 2) {
                return this.getFolders(webDAVRequest);
            }
            if (pathArray.length == 3) {
                String type = pathArray[2];
                if (type.equals("Structures")) {
                    return this.getStructures(webDAVRequest);
                }
                if (type.equals("Templates")) {
                    return this.getTemplates(webDAVRequest);
                }
            }
            return new ArrayList<Resource>();
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    public int putResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return DDMWebDavUtil.putResource(webDAVRequest, this.getRootPath(), this.getToken(), PortalUtil.getClassNameId(JournalArticle.class));
    }

    protected List<Resource> getFolders(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(DDMWebDavUtil.toResource(webDAVRequest, "Structures", this.getRootPath(), true));
        resources.add(DDMWebDavUtil.toResource(webDAVRequest, "Templates", this.getRootPath(), true));
        return resources;
    }

    protected List<Resource> getStructures(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List ddmStructures = DDMStructureLocalServiceUtil.getStructures((long)webDAVRequest.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class));
        for (DDMStructure ddmStructure : ddmStructures) {
            Resource resource = DDMWebDavUtil.toResource(webDAVRequest, ddmStructure, this.getRootPath(), true);
            resources.add(resource);
        }
        return resources;
    }

    protected List<Resource> getTemplates(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List ddmTemplates = DDMTemplateLocalServiceUtil.getTemplatesByStructureClassNameId((long)webDAVRequest.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (int)-1, (int)-1, null);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            Resource resource = DDMWebDavUtil.toResource(webDAVRequest, ddmTemplate, this.getRootPath(), true);
            resources.add(resource);
        }
        return resources;
    }
}

