/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.util.Table;

public abstract class BaseUpgradeTableImpl
extends Table {
    private static Log _log = LogFactoryUtil.getLog(BaseUpgradeTableImpl.class);
    private boolean _allowUniqueIndexes;
    private boolean _calledUpdateTable;
    private boolean _deleteTempFile;
    private String[] _indexesSQL = new String[0];
    private String _tempFileName;

    public BaseUpgradeTableImpl(String tableName) {
        super(tableName);
    }

    public BaseUpgradeTableImpl(String tableName, Object[][] columns) {
        super(tableName, columns);
    }

    public String[] getIndexesSQL() throws Exception {
        return this._indexesSQL;
    }

    public String getTempFileName() {
        return this._tempFileName;
    }

    public boolean isAllowUniqueIndexes() throws Exception {
        return this._allowUniqueIndexes;
    }

    public boolean isDeleteTempFile() {
        return this._deleteTempFile;
    }

    public void setAllowUniqueIndexes(boolean allowUniqueIndexes) throws Exception {
        this._allowUniqueIndexes = allowUniqueIndexes;
    }

    @Override
    public void setCreateSQL(String createSQL) throws Exception {
        if (this._calledUpdateTable) {
            throw new UpgradeException("setCreateSQL is called after updateTable");
        }
        super.setCreateSQL(createSQL);
    }

    public void setDeleteTempFile(boolean deleteTempFile) {
        this._deleteTempFile = deleteTempFile;
    }

    public void setIndexesSQL(String[] indexesSQL) throws Exception {
        this._indexesSQL = indexesSQL;
    }

    public void updateTable() throws Exception {
        this._calledUpdateTable = true;
        this._tempFileName = this.generateTempFile();
        try {
            String createSQL;
            DB db = DBFactoryUtil.getDB();
            if (Validator.isNotNull((String)this._tempFileName)) {
                String deleteSQL = this.getDeleteSQL();
                db.runSQL(deleteSQL);
            }
            if (Validator.isNotNull((String)(createSQL = this.getCreateSQL()))) {
                db.runSQL("drop table " + this.getTableName());
                db.runSQL(createSQL);
            }
            if (Validator.isNotNull((String)this._tempFileName)) {
                this.populateTable(this._tempFileName);
            }
            String[] indexesSQL = this.getIndexesSQL();
            boolean dropIndexes = false;
            String[] stringArray = indexesSQL;
            int n = indexesSQL.length;
            int n2 = 0;
            while (n2 < n) {
                block12: {
                    String indexSQL = stringArray[n2];
                    if (!this.isAllowUniqueIndexes() && indexSQL.contains("create unique index")) {
                        indexSQL = StringUtil.replace((String)indexSQL, (String)"create unique index ", (String)"create index ");
                        dropIndexes = true;
                    }
                    try {
                        db.runSQL(indexSQL);
                    }
                    catch (Exception e2) {
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Object)(String.valueOf(e2.getMessage()) + ": " + indexSQL));
                    }
                }
                ++n2;
            }
            if (dropIndexes) {
                StartupHelperUtil.setDropIndexes(true);
            }
        }
        finally {
            if (Validator.isNotNull((String)this._tempFileName) && this._deleteTempFile) {
                FileUtil.delete((String)this._tempFileName);
            }
        }
    }
}

