/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistry;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DoPrivileged
public class TemplateHandlerRegistryImpl
implements TemplateHandlerRegistry {
    private Map<String, TemplateHandler> _templateHandlers = new HashMap<String, TemplateHandler>();

    public long[] getClassNameIds() {
        long[] classNameIds = new long[this._templateHandlers.size()];
        int i2 = 0;
        for (Map.Entry<String, TemplateHandler> entry : this._templateHandlers.entrySet()) {
            TemplateHandler templateHandler = entry.getValue();
            classNameIds[i2++] = PortalUtil.getClassNameId((String)templateHandler.getClassName());
        }
        return classNameIds;
    }

    public TemplateHandler getTemplateHandler(long classNameId) {
        String className = PortalUtil.getClassName((long)classNameId);
        return this._templateHandlers.get(className);
    }

    public TemplateHandler getTemplateHandler(String className) {
        return this._templateHandlers.get(className);
    }

    public List<TemplateHandler> getTemplateHandlers() {
        return ListUtil.fromMapValues(this._templateHandlers);
    }

    public void register(TemplateHandler templateHandler) {
        this._templateHandlers.put(templateHandler.getClassName(), templateHandler);
    }

    public void unregister(TemplateHandler templateHandler) {
        this._templateHandlers.remove(templateHandler.getClassName());
    }
}

