/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.googleapps;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import java.util.Properties;

public class GAuthenticator {
    private static final long _EXPIRE_TIME = 3600000L;
    private static Log _log = LogFactoryUtil.getLog(GAuthenticator.class);
    private String _authenticationToken;
    private long _companyId;
    private String _domain;
    private String _error;
    private long _initTime;
    private String _password;
    private String _userName;

    public GAuthenticator(long companyId) {
        this._companyId = companyId;
        this.init(true);
    }

    public GAuthenticator(String domain, String userName, String password) {
        this._domain = domain;
        this._userName = userName;
        this._password = password;
        this.init(true);
    }

    public String getAuthenticationToken() {
        this.init(false);
        return this._authenticationToken;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getError() {
        return this._error;
    }

    public void init(boolean manual) {
        if (manual || this.isStale()) {
            try {
                this.doInit();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
    }

    protected void doInit() throws Exception {
        if (this._companyId > 0L) {
            Company company = CompanyLocalServiceUtil.getCompany((long)this._companyId);
            this._domain = company.getMx();
            this._userName = PrefsPropsUtil.getString(this._companyId, "google.apps.username");
            this._password = PrefsPropsUtil.getString(this._companyId, "google.apps.password");
        }
        Http.Options options = new Http.Options();
        options.addPart("accountType", "HOSTED");
        String emailAddress = this._userName;
        if (!emailAddress.contains("@")) {
            emailAddress = this._userName.concat("@").concat(this._domain);
        }
        options.addPart("Email", emailAddress);
        options.addPart("Passwd", this._password);
        options.addPart("service", "apps");
        options.setLocation("https://www.google.com/accounts/ClientLogin");
        options.setPost(true);
        String content = HttpUtil.URLtoString((Http.Options)options);
        Properties properties = PropertiesUtil.load((String)content);
        this._error = properties.getProperty("Error");
        if (this._error != null && _log.isInfoEnabled()) {
            _log.info((Object)("Unable to initialize authentication token: " + this._error));
        }
        this._authenticationToken = properties.getProperty("Auth");
        if (this._authenticationToken != null && _log.isInfoEnabled()) {
            _log.info((Object)("Authentication token " + this._authenticationToken));
        }
        this._initTime = System.currentTimeMillis();
    }

    protected boolean isStale() {
        return this._initTime + 3600000L <= System.currentTimeMillis();
    }
}

