/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.auto.MVCPortletAutoDeployer;
import com.liferay.portal.deploy.auto.PHPPortletAutoDeployer;
import com.liferay.portal.deploy.auto.PortletAutoDeployer;
import com.liferay.portal.deploy.auto.ThreadSafeAutoDeployer;
import com.liferay.portal.deploy.auto.WAIAutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.BaseAutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;

public class PortletAutoDeployListener
extends BaseAutoDeployListener {
    private static Log _log = LogFactoryUtil.getLog(PortletAutoDeployListener.class);
    private AutoDeployer _autoDeployer = new PortletAutoDeployer();
    private MVCPortletAutoDeployer _mvcPortletAutoDeployer;
    private PHPPortletAutoDeployer _phpPortletAutoDeployer;
    private WAIAutoDeployer _waiAutoDeployer;

    public int deploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        int code;
        File file = autoDeploymentContext.getFile();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + file.getPath()));
        }
        AutoDeployer autoDeployer = null;
        if (this.isMatchingFile(file, "WEB-INF/portlet.xml")) {
            autoDeployer = this._autoDeployer;
        } else if (this.isMatchingFile(file, "index_mvc.jsp")) {
            autoDeployer = this.getMvcDeployer();
        } else if (this.isMatchingFile(file, "index.php")) {
            autoDeployer = this.getPhpDeployer();
        } else if (!(this.isExtPlugin(file) || this.isHookPlugin(file) || this.isMatchingFile(file, "WEB-INF/liferay-layout-templates.xml") || this.isThemePlugin(file) || this.isWebPlugin(file) || !file.getName().endsWith(".war"))) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Deploying package as a web application");
            }
            autoDeployer = this.getWaiDeployer();
        } else {
            return 0;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Copying portlets for " + file.getPath()));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Using deployer " + autoDeployer.getClass().getName()));
        }
        if ((code = (autoDeployer = new ThreadSafeAutoDeployer(autoDeployer)).autoDeploy(autoDeploymentContext)) == 1 && _log.isInfoEnabled()) {
            _log.info((Object)("Portlets for " + file.getPath() + " copied successfully. " + "Deployment will start in a few seconds."));
        }
        return code;
    }

    protected AutoDeployer getMvcDeployer() {
        if (this._mvcPortletAutoDeployer == null) {
            this._mvcPortletAutoDeployer = new MVCPortletAutoDeployer();
        }
        return this._mvcPortletAutoDeployer;
    }

    protected AutoDeployer getPhpDeployer() throws AutoDeployException {
        if (this._phpPortletAutoDeployer == null) {
            this._phpPortletAutoDeployer = new PHPPortletAutoDeployer();
        }
        return this._phpPortletAutoDeployer;
    }

    protected AutoDeployer getWaiDeployer() throws AutoDeployException {
        if (this._waiAutoDeployer == null) {
            this._waiAutoDeployer = new WAIAutoDeployer();
        }
        return this._waiAutoDeployer;
    }
}

