/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.xerces.impl.dv.util.Base64;
import org.walluck.io.DataOutputStreamEx;

public class ProxyConnection {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$net$ProxyConnection == null ? (class$org$walluck$net$ProxyConnection = ProxyConnection.class$("org.walluck.net.ProxyConnection")) : class$org$walluck$net$ProxyConnection).getName());
    public static final int PROXY_TYPE_SOCKS4 = 1;
    public static final int PROXY_TYPE_SOCKS5 = 2;
    public static final int PROXY_TYPE_HTTP = 3;
    private int socksRevision;
    private int type;
    private String user;
    private String password;
    private boolean useJavaInternal = false;
    private Socket socket;
    private URLConnection uc;
    private String host;
    private int port;
    private String proxyHost;
    private int proxyPort;
    static /* synthetic */ Class class$org$walluck$net$ProxyConnection;

    public void connect(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        switch (this.type) {
            case 1: {
                this.socksRevision = 4;
                if (this.useJavaInternal) {
                    Properties properties = System.getProperties();
                    properties.put("proxySet", "yes");
                    properties.put("socksProxyHost", host);
                    properties.put("socksProxyPort", "" + port);
                }
                this.connectSocks4();
                break;
            }
            case 2: {
                this.socksRevision = 5;
                if (this.useJavaInternal) {
                    Properties properties = System.getProperties();
                    properties.put("socksProxyHost", host);
                    properties.put("socksProxyPort", "" + port);
                }
                this.connectSocks5();
                break;
            }
            case 3: {
                Properties properties = System.getProperties();
                properties.put("http.agent", "AIM/30 (Mozilla 1.24b; Windows ; I; 32-bit)");
                if (this.useJavaInternal) {
                    properties.put("http.proxyHost", host);
                    properties.put("http.proxyPort", "" + port);
                }
                this.connectHTTP();
                break;
            }
            default: {
                String errMsg = "Unknown proxy type " + this.type;
                LOG.error((Object)errMsg, (Throwable)new IOException(errMsg));
            }
        }
    }

    private void connectSocks4() throws IOException {
        byte[] buf = new byte[16];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStreamEx dos = new DataOutputStreamEx(baos);
        String errMsg = null;
        this.socket = new Socket(this.proxyHost, this.proxyPort);
        OutputStream os = this.socket.getOutputStream();
        InputStream is = this.socket.getInputStream();
        dos.writeByte(4);
        dos.writeByte(1);
        dos.writeShort(this.port);
        dos.writeBytes(this.socket.getInetAddress().getAddress());
        if (this.password != null) {
            dos.writeString0(this.password);
        }
        dos.writeString0(this.host);
        os.write(baos.toByteArray());
        baos.reset();
        int read = is.read(buf, 0, 2);
        if (read != 2 || buf[0] != 4) {
            errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Server returned wrong version " + buf[0];
        }
        if (buf[1] == 90) {
            return;
        }
        if (buf[1] == 91) {
            errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Request rejected.";
        } else if (buf[1] == 92) {
            errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Cannot connect to identd server on client" + " side.";
        } else if (buf[1] == 93) {
            errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Request rejected. Client reports different" + " username than identd server.";
        }
        if (errMsg != null) {
            LOG.error((Object)errMsg, (Throwable)new IOException(errMsg));
        }
    }

    private void connectSocks5() throws IOException {
        byte[] buf = new byte[16];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStreamEx dos = new DataOutputStreamEx(baos);
        String errMsg = null;
        this.socket = new Socket(this.proxyHost, this.proxyPort);
        OutputStream os = this.socket.getOutputStream();
        InputStream is = this.socket.getInputStream();
        buf[0] = 5;
        if (this.user != null) {
            buf[1] = 2;
            buf[2] = 0;
            buf[3] = 2;
        } else {
            buf[1] = 1;
            buf[2] = 0;
        }
        os.write(buf);
        int read = is.read(buf, 0, 1);
        if (read != 1 || buf[0] != 5) {
            errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Server returned wrong version " + buf[0];
        }
        if (buf[1] == 255) {
            errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Try specifying a username or password";
        }
        if (buf[1] == 2) {
            if (this.user == null) {
                errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. You did not specify a SOCKS username";
            }
            dos.writeByte(1);
            dos.writeStringL(this.user);
            dos.writeStringL(this.password);
            os.write(baos.toByteArray());
            baos.reset();
            read = is.read(buf, 0, 2);
            if (read != 2 || buf[0] != 1 || buf[1] != 0) {
                switch (buf[1]) {
                    case 1: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Connection failed.";
                        break;
                    }
                    case 2: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Connection not allowed.";
                        break;
                    }
                    case 3: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Network unreachable.";
                        break;
                    }
                    case 4: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Host unreachable.";
                        break;
                    }
                    case 5: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Connection refused.";
                        break;
                    }
                    case 6: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. TTL expired.";
                        break;
                    }
                    case 7: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Command type not supported.";
                        break;
                    }
                    case 8: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Address not supported.";
                        break;
                    }
                    case 9: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Invalid address.";
                        break;
                    }
                    default: {
                        errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Unknown Error.";
                    }
                }
            }
        }
        dos.writeByte(5);
        dos.writeByte(1);
        dos.writeByte(0);
        dos.writeByte(3);
        dos.writeByte(this.host.length());
        dos.writeString(this.host);
        dos.writeShort(this.port);
        os.write(baos.toByteArray());
        baos.reset();
        read = is.read(buf, 0, 2);
        if (read != 2 || buf[0] != 5) {
            errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy. Server returned wrong version " + buf[0];
        }
        if (buf[1] != 0) {
            errMsg = "Error connecting to SOCKS v" + this.socksRevision + " proxy";
        }
        if (errMsg != null) {
            LOG.error((Object)errMsg, (Throwable)new IOException(errMsg));
        }
    }

    private void connectHTTP() throws IOException {
        String auth = null;
        boolean wantAuth = false;
        String httpHost = "";
        if (this.user != null && this.password != null) {
            String s = this.user + ":" + this.password;
            auth = "Basic " + Base64.encode((byte[])s.getBytes());
            wantAuth = true;
        }
        if (!this.proxyHost.toLowerCase().startsWith("http://")) {
            httpHost = "http://" + this.proxyHost;
        }
        httpHost = httpHost + ":" + this.port;
        if (wantAuth) {
            this.uc.setRequestProperty("Proxy-authorization", auth);
        }
        URL url = new URL(httpHost);
        this.uc = url.openConnection();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean useJavaInternal() {
        return this.useJavaInternal;
    }

    public void setUseJavaInternal(boolean useJavaInternal) {
        this.useJavaInternal = useJavaInternal;
    }

    public String getProxyHost() {
        return this.host;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.port;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public URLConnection getURLConnection() {
        return this.uc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

