/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class ProcStat
implements Serializable {
    private static final long serialVersionUID = 7546L;
    long total = 0L;
    long idle = 0L;
    long running = 0L;
    long sleeping = 0L;
    long stopped = 0L;
    long zombie = 0L;
    long threads = 0L;

    public native void gather(Sigar var1) throws SigarException;

    static ProcStat fetch(Sigar sigar) throws SigarException {
        ProcStat procStat = new ProcStat();
        procStat.gather(sigar);
        return procStat;
    }

    public long getTotal() {
        return this.total;
    }

    public long getIdle() {
        return this.idle;
    }

    public long getRunning() {
        return this.running;
    }

    public long getSleeping() {
        return this.sleeping;
    }

    public long getStopped() {
        return this.stopped;
    }

    public long getZombie() {
        return this.zombie;
    }

    public long getThreads() {
        return this.threads;
    }

    void copyTo(ProcStat copy) {
        copy.total = this.total;
        copy.idle = this.idle;
        copy.running = this.running;
        copy.sleeping = this.sleeping;
        copy.stopped = this.stopped;
        copy.zombie = this.zombie;
        copy.threads = this.threads;
    }

    public Map toMap() {
        String strthreads;
        String strzombie;
        String strstopped;
        String strsleeping;
        String strrunning;
        String stridle;
        HashMap<String, String> map = new HashMap<String, String>();
        String strtotal = String.valueOf(this.total);
        if (!"-1".equals(strtotal)) {
            map.put("Total", strtotal);
        }
        if (!"-1".equals(stridle = String.valueOf(this.idle))) {
            map.put("Idle", stridle);
        }
        if (!"-1".equals(strrunning = String.valueOf(this.running))) {
            map.put("Running", strrunning);
        }
        if (!"-1".equals(strsleeping = String.valueOf(this.sleeping))) {
            map.put("Sleeping", strsleeping);
        }
        if (!"-1".equals(strstopped = String.valueOf(this.stopped))) {
            map.put("Stopped", strstopped);
        }
        if (!"-1".equals(strzombie = String.valueOf(this.zombie))) {
            map.put("Zombie", strzombie);
        }
        if (!"-1".equals(strthreads = String.valueOf(this.threads))) {
            map.put("Threads", strthreads);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

