/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class FileSystem
implements Serializable {
    private static final long serialVersionUID = 9641L;
    String dirName = null;
    String devName = null;
    String typeName = null;
    String sysTypeName = null;
    String options = null;
    int type = 0;
    long flags = 0L;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_NONE = 1;
    public static final int TYPE_LOCAL_DISK = 2;
    public static final int TYPE_NETWORK = 3;
    public static final int TYPE_RAM_DISK = 4;
    public static final int TYPE_CDROM = 5;
    public static final int TYPE_SWAP = 6;

    public native void gather(Sigar var1) throws SigarException;

    static FileSystem fetch(Sigar sigar) throws SigarException {
        FileSystem fileSystem = new FileSystem();
        fileSystem.gather(sigar);
        return fileSystem;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getDevName() {
        return this.devName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getSysTypeName() {
        return this.sysTypeName;
    }

    public String getOptions() {
        return this.options;
    }

    public int getType() {
        return this.type;
    }

    public long getFlags() {
        return this.flags;
    }

    void copyTo(FileSystem copy) {
        copy.dirName = this.dirName;
        copy.devName = this.devName;
        copy.typeName = this.typeName;
        copy.sysTypeName = this.sysTypeName;
        copy.options = this.options;
        copy.type = this.type;
        copy.flags = this.flags;
    }

    public String toString() {
        return this.getDirName();
    }

    public Map toMap() {
        String strflags;
        String strtype;
        String stroptions;
        String strsysTypeName;
        String strtypeName;
        String strdevName;
        HashMap<String, String> map = new HashMap<String, String>();
        String strdirName = String.valueOf(this.dirName);
        if (!"-1".equals(strdirName)) {
            map.put("DirName", strdirName);
        }
        if (!"-1".equals(strdevName = String.valueOf(this.devName))) {
            map.put("DevName", strdevName);
        }
        if (!"-1".equals(strtypeName = String.valueOf(this.typeName))) {
            map.put("TypeName", strtypeName);
        }
        if (!"-1".equals(strsysTypeName = String.valueOf(this.sysTypeName))) {
            map.put("SysTypeName", strsysTypeName);
        }
        if (!"-1".equals(stroptions = String.valueOf(this.options))) {
            map.put("Options", stroptions);
        }
        if (!"-1".equals(strtype = String.valueOf(this.type))) {
            map.put("Type", strtype);
        }
        if (!"-1".equals(strflags = String.valueOf(this.flags))) {
            map.put("Flags", strflags);
        }
        return map;
    }
}

