/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import lombok.javac.JavacNode;
import lombok.javac.JavacResolution;

public enum JavacResolver {
    CLASS{

        @Override
        public Type resolveMember(JavacNode node, JCTree.JCExpression expr) {
            Type type = expr.type;
            if (type == null) {
                try {
                    new JavacResolution(node.getContext()).resolveClassMember(node);
                    type = expr.type;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            return type;
        }
    }
    ,
    METHOD{

        @Override
        public Type resolveMember(JavacNode node, JCTree.JCExpression expr) {
            Type type = expr.type;
            if (type == null) {
                try {
                    JCTree.JCExpression resolvedExpression = (JCTree.JCExpression)new JavacResolution(node.getContext()).resolveMethodMember(node).get(expr);
                    if (resolvedExpression != null) {
                        type = resolvedExpression.type;
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            return type;
        }
    }
    ,
    CLASS_AND_METHOD{

        @Override
        public Type resolveMember(JavacNode node, JCTree.JCExpression expr) {
            Type type = METHOD.resolveMember(node, expr);
            if (type == null) {
                JavacNode classNode;
                for (classNode = node; classNode != null && this.noneOf(classNode.get(), JCTree.JCBlock.class, JCTree.JCMethodDecl.class, JCTree.JCVariableDecl.class); classNode = (JavacNode)classNode.up()) {
                }
                if (classNode != null) {
                    type = CLASS.resolveMember(classNode, expr);
                }
            }
            return type;
        }

        private boolean noneOf(Object o, Class<?> ... clazzes) {
            for (Class<?> clazz : clazzes) {
                if (!clazz.isInstance(o)) continue;
                return false;
            }
            return true;
        }
    };


    public abstract Type resolveMember(JavacNode var1, JCTree.JCExpression var2);
}

