/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ContextExposingHttpServletRequest;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalResourceView
extends AbstractUrlBasedView {
    private boolean alwaysInclude = false;
    private volatile Boolean exposeForwardAttributes;
    private boolean exposeContextBeansAsAttributes = false;
    private Set<String> exposedContextBeanNames;
    private boolean preventDispatchLoop = false;

    public InternalResourceView() {
    }

    public InternalResourceView(String url) {
        super(url);
    }

    public InternalResourceView(String url, boolean alwaysInclude) {
        super(url);
        this.alwaysInclude = alwaysInclude;
    }

    public void setAlwaysInclude(boolean alwaysInclude) {
        this.alwaysInclude = alwaysInclude;
    }

    public void setExposeForwardAttributes(boolean exposeForwardAttributes) {
        this.exposeForwardAttributes = exposeForwardAttributes;
    }

    public void setExposeContextBeansAsAttributes(boolean exposeContextBeansAsAttributes) {
        this.exposeContextBeansAsAttributes = exposeContextBeansAsAttributes;
    }

    public void setExposedContextBeanNames(String[] exposedContextBeanNames) {
        this.exposedContextBeanNames = new HashSet<String>((Collection)Arrays.asList(exposedContextBeanNames));
    }

    public void setPreventDispatchLoop(boolean preventDispatchLoop) {
        this.preventDispatchLoop = preventDispatchLoop;
    }

    protected boolean isContextRequired() {
        return false;
    }

    protected void initServletContext(ServletContext sc) {
        if (this.exposeForwardAttributes == null && sc.getMajorVersion() == 2 && sc.getMinorVersion() < 5) {
            this.exposeForwardAttributes = Boolean.TRUE;
        }
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpServletRequest requestToExpose = this.getRequestToExpose(request);
        this.exposeModelAsRequestAttributes(model, requestToExpose);
        this.exposeHelpers(requestToExpose);
        String dispatcherPath = this.prepareForRendering(requestToExpose, response);
        RequestDispatcher rd = this.getRequestDispatcher(requestToExpose, dispatcherPath);
        if (rd == null) {
            throw new ServletException("Could not get RequestDispatcher for [" + this.getUrl() + "]: Check that the corresponding file exists within your web application archive!");
        }
        if (this.useInclude(requestToExpose, response)) {
            response.setContentType(this.getContentType());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Including resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
            rd.include((ServletRequest)requestToExpose, (ServletResponse)response);
        } else {
            this.exposeForwardRequestAttributes(requestToExpose);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Forwarding to resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
            rd.forward((ServletRequest)requestToExpose, (ServletResponse)response);
        }
    }

    protected HttpServletRequest getRequestToExpose(HttpServletRequest originalRequest) {
        if (this.exposeContextBeansAsAttributes || this.exposedContextBeanNames != null) {
            return new ContextExposingHttpServletRequest(originalRequest, this.getWebApplicationContext(), this.exposedContextBeanNames);
        }
        return originalRequest;
    }

    protected void exposeHelpers(HttpServletRequest request) throws Exception {
    }

    protected String prepareForRendering(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = this.getUrl();
        if (this.preventDispatchLoop) {
            String uri = request.getRequestURI();
            if (path.startsWith("/") ? uri.equals(path) : uri.equals(StringUtils.applyRelativePath((String)uri, (String)path))) {
                throw new ServletException("Circular view path [" + path + "]: would dispatch back " + "to the current handler URL [" + uri + "] again. Check your ViewResolver setup! " + "(Hint: This may be the result of an unspecified view, due to default view name generation.)");
            }
        }
        return path;
    }

    protected RequestDispatcher getRequestDispatcher(HttpServletRequest request, String path) {
        return request.getRequestDispatcher(path);
    }

    protected boolean useInclude(HttpServletRequest request, HttpServletResponse response) {
        return this.alwaysInclude || WebUtils.isIncludeRequest((ServletRequest)request) || response.isCommitted();
    }

    protected void exposeForwardRequestAttributes(HttpServletRequest request) {
        if (this.exposeForwardAttributes != null && this.exposeForwardAttributes.booleanValue()) {
            try {
                WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
            }
            catch (Exception exception) {
                this.exposeForwardAttributes = Boolean.FALSE;
            }
        }
    }
}

