/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.binary.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetOperationImpl
extends OperationImpl
implements GetOperation,
GetsOperation {
    static final int CMD = 0;
    static final int EXTRA_HDR_LEN = 4;
    private final String key;

    public GetOperationImpl(String k, GetOperation.Callback cb) {
        super(0, GetOperationImpl.generateOpaque(), cb);
        this.key = k;
    }

    public GetOperationImpl(String k, GetsOperation.Callback cb) {
        super(0, GetOperationImpl.generateOpaque(), cb);
        this.key = k;
    }

    @Override
    public void initialize() {
        this.prepareBuffer(this.key, 0L, EMPTY_BYTES, new Object[0]);
    }

    @Override
    protected void decodePayload(byte[] pl) {
        int flags = GetOperationImpl.decodeInt(pl, 0);
        byte[] data = new byte[pl.length - 4];
        System.arraycopy(pl, 4, data, 0, pl.length - 4);
        try {
            GetOperation.Callback cb = (GetOperation.Callback)this.getCallback();
            cb.gotData(this.key, flags, data);
        }
        catch (ClassCastException e) {
            GetsOperation.Callback cb = (GetsOperation.Callback)this.getCallback();
            cb.gotData(this.key, flags, this.responseCas, data);
        }
        this.getCallback().receivedStatus(STATUS_OK);
    }

    @Override
    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        return errCode == 1 ? NOT_FOUND_STATUS : null;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

