/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.rmi.remote.RemoteItem;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerItem
extends ServerObject
implements RemoteItem {
    private Item item;

    public ServerItem(Item item, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.item = item;
    }

    public String getPath() throws RepositoryException, RemoteException {
        try {
            return this.item.getPath();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public String getName() throws RepositoryException, RemoteException {
        try {
            return this.item.getName();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void save() throws RepositoryException, RemoteException {
        try {
            this.item.save();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteItem getAncestor(int level) throws RepositoryException, RemoteException {
        try {
            return this.getRemoteItem(this.item.getAncestor(level));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public int getDepth() throws RepositoryException, RemoteException {
        try {
            return this.item.getDepth();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteNode getParent() throws RepositoryException, RemoteException {
        try {
            return this.getRemoteNode(this.item.getParent());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean isModified() throws RemoteException {
        return this.item.isModified();
    }

    public boolean isNew() throws RemoteException {
        return this.item.isNew();
    }

    public void refresh(boolean keepChanges) throws RepositoryException, RemoteException {
        try {
            this.item.refresh(keepChanges);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void remove() throws RepositoryException, RemoteException {
        try {
            this.item.remove();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

