/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view;

import java.awt.Color;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class Console
implements Observer {
    private static Console console = null;
    PrintStream printStream;
    PipedOutputStream poCustom;
    PipedInputStream piCustom;
    PipedOutputStream poOut;
    PipedInputStream piOut;
    PipedOutputStream poErr;
    PipedInputStream piErr;
    ConsoleStyleContext styleContext = new ConsoleStyleContext();
    JTextPane textArea = new JTextPane(new DefaultStyledDocument(this.styleContext));

    private Console() throws IOException {
        this.piCustom = new PipedInputStream();
        this.poCustom = new PipedOutputStream();
        this.printStream = new PrintStream(this.poCustom);
        this.piOut = new PipedInputStream();
        this.poOut = new PipedOutputStream(this.piOut);
        System.setOut(new PrintStream(this.poOut, true));
        this.piErr = new PipedInputStream();
        this.poErr = new PipedOutputStream(this.piErr);
        System.setErr(new PrintStream(this.poErr, true));
        this.textArea.setEditable(false);
        new ReadWriteThread(this.piCustom, "Custom").start();
        new ReadWriteThread(this.piOut, "SystemOut").start();
        new ReadWriteThread(this.piErr, "SystemErr").start();
    }

    public static synchronized Console getInstance() {
        if (console == null) {
            try {
                console = new Console();
            }
            catch (IOException e) {
                console = null;
            }
        }
        return console;
    }

    public void update(Observable observable, Object obj) {
        if ("Close".equals(obj)) {
            this.textArea.setText("");
        }
        if ("Open".equals(obj)) {
            this.textArea.setText("");
        }
    }

    public static void println(String s) {
        PrintStream ps = Console.getInstance().getPrintStream();
        if (ps == null) {
            System.out.println(s);
        } else {
            ps.println(s);
            ps.flush();
        }
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public JTextPane getTextArea() {
        return this.textArea;
    }

    class ConsoleStyleContext
    extends StyleContext {
        private static final long serialVersionUID = 7253870053566811171L;
        public static final String CUSTOM = "Custom";
        public static final String SYSTEMOUT = "SystemOut";
        public static final String SYSTEMERR = "SystemErr";

        public ConsoleStyleContext() {
            Style root = this.getStyle("default");
            Style s = this.addStyle(CUSTOM, root);
            StyleConstants.setForeground(s, Color.BLACK);
            s = this.addStyle(SYSTEMOUT, root);
            StyleConstants.setForeground(s, Color.GREEN);
            s = this.addStyle(SYSTEMERR, root);
            StyleConstants.setForeground(s, Color.RED);
        }
    }

    class ReadWriteThread
    extends Thread {
        PipedInputStream pi;
        String type;

        ReadWriteThread(PipedInputStream pi, String type) {
            this.pi = pi;
            this.type = type;
        }

        public void run() {
            byte[] buf = new byte[1024];
            while (true) {
                try {
                    int len;
                    while ((len = this.pi.read(buf)) != -1) {
                        Document doc = Console.this.textArea.getDocument();
                        Style attset = Console.this.styleContext.getStyle(this.type);
                        String snippet = new String(buf, 0, len);
                        doc.insertString(doc.getLength(), snippet, attset);
                        Console.this.printStream.print(snippet);
                        Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                    }
                }
                catch (BadLocationException ex) {
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }
}

