/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import net.sf.ehcache.Element;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.Environment;
import org.jamwiki.WikiBase;
import org.jamwiki.WikiException;
import org.jamwiki.WikiMessage;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicType;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.model.WikiFile;
import org.jamwiki.model.WikiFileVersion;
import org.jamwiki.model.WikiImage;
import org.jamwiki.model.WikiUser;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.ParserUtil;
import org.jamwiki.utils.ImageBorderEnum;
import org.jamwiki.utils.ImageHorizontalAlignmentEnum;
import org.jamwiki.utils.ImageMetadata;
import org.jamwiki.utils.ImageProcessor;
import org.jamwiki.utils.ImageVerticalAlignmentEnum;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiCache;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.WikiUtil;

public class ImageUtil {
    private static final WikiLogger logger = WikiLogger.getLogger(ImageUtil.class.getName());
    private static final String CACHE_IMAGE_DIMENSIONS = "org.jamwiki.utils.ImageUtil.CACHE_IMAGE_DIMENSIONS";
    private static final String RESIZED_IMAGE_SUBFOLDER = "resized";

    private ImageUtil() {
    }

    private static void addToCache(WikiImage wikiImage, Dimension dimensions) {
        String key = wikiImage.getVirtualWiki() + "/" + wikiImage.getUrl();
        WikiCache.addToCache(CACHE_IMAGE_DIMENSIONS, key, dimensions);
    }

    public static String buildImageFileUrl(String virtualWiki, String topicName) throws DataAccessException {
        WikiFile wikiFile = WikiBase.getDataHandler().lookupWikiFile(virtualWiki, topicName);
        if (wikiFile == null) {
            return null;
        }
        return ImageUtil.buildRelativeImageUrl(wikiFile.getUrl());
    }

    private static String buildRelativeImageUrl(String filename) {
        String url = FilenameUtils.normalize((String)(Environment.getValue("file-dir-relative-path") + "/" + filename));
        return FilenameUtils.separatorsToUnix((String)url);
    }

    public static String buildImageLinkHtml(String context, String linkVirtualWiki, String topicName, ImageMetadata imageMetadata, String style, boolean escapeHtml) throws DataAccessException, IOException {
        String url = ImageUtil.buildImageFileUrl(linkVirtualWiki, topicName);
        if (url == null) {
            return ImageUtil.buildUploadLink(context, linkVirtualWiki, topicName);
        }
        Topic topic = WikiBase.getDataHandler().lookupTopic(linkVirtualWiki, topicName, false, null);
        StringBuilder html = new StringBuilder();
        String caption = imageMetadata.getCaption();
        if (topic.getTopicType() == TopicType.FILE) {
            return ImageUtil.buildLinkToFile(url, topic, caption, escapeHtml);
        }
        WikiFile wikiFile = WikiBase.getDataHandler().lookupWikiFile(topic.getVirtualWiki(), topic.getName());
        WikiImage wikiImage = null;
        try {
            wikiImage = ImageUtil.initializeWikiImage(wikiFile, imageMetadata);
        }
        catch (FileNotFoundException e) {
            logger.warn("File not found while parsing image link for topic: " + topic.getVirtualWiki() + " / " + topicName + ".  Make sure that the following file exists and is readable by the JAMWiki installation: " + e.getMessage());
            return ImageUtil.buildUploadLink(context, topic.getVirtualWiki(), topicName);
        }
        if (wikiImage == null) {
            return ImageUtil.buildLinkToFile(url, topic, caption, escapeHtml);
        }
        String imageWrapperDiv = ImageUtil.buildImageWrapperDivs(imageMetadata, wikiImage.getWidth());
        if (!StringUtils.isWhitespace((String)imageMetadata.getLink())) {
            if (imageMetadata.getLink() == null) {
                String link = LinkUtil.buildTopicUrl(context, linkVirtualWiki, topicName, false);
                html.append("<a class=\"wikiimg\" href=\"").append(link).append("\">");
            } else {
                try {
                    String openTag = LinkUtil.buildHtmlLinkOpenTag(imageMetadata.getLink(), "wikiimg");
                    html.append(openTag);
                }
                catch (ParserException e) {
                    WikiLink wikiLink = LinkUtil.parseWikiLink(topic.getVirtualWiki(), imageMetadata.getLink());
                    String internalLinkVirtualWiki = wikiLink.getVirtualWiki() != null ? wikiLink.getVirtualWiki().getName() : linkVirtualWiki;
                    String link = LinkUtil.buildTopicUrl(context, internalLinkVirtualWiki, wikiLink);
                    html.append("<a class=\"wikiimg\" href=\"").append(link).append("\">");
                }
            }
        }
        if (StringUtils.isBlank((String)style)) {
            style = "wikiimg";
        }
        if (imageMetadata.getBordered()) {
            style = style + " thumbborder";
        }
        html.append("<img class=\"").append(style).append("\" src=\"");
        html.append(ImageUtil.buildRelativeImageUrl(wikiImage.getUrl()));
        html.append('\"');
        html.append(" width=\"").append(wikiImage.getWidth()).append('\"');
        html.append(" height=\"").append(wikiImage.getHeight()).append('\"');
        String alt = imageMetadata.getAlt();
        html.append(" alt=\"").append(StringEscapeUtils.escapeHtml((String)alt)).append('\"');
        if (imageMetadata.getVerticalAlignment() != ImageVerticalAlignmentEnum.NOT_SPECIFIED) {
            html.append(" style=\"vertical-align: ").append(imageMetadata.getVerticalAlignment().toString()).append('\"');
        }
        html.append(" />");
        if (!StringUtils.isWhitespace((String)imageMetadata.getLink())) {
            html.append("</a>");
        }
        if (!StringUtils.isBlank((String)caption)) {
            html.append("\n<div class=\"thumbcaption\">");
            if (escapeHtml) {
                html.append(StringEscapeUtils.escapeHtml((String)caption));
            } else {
                html.append(caption);
            }
            html.append("</div>\n");
        }
        return MessageFormat.format(imageWrapperDiv, html.toString());
    }

    private static String buildImagePath(String currentUrl, int originalWidth, int scaledWidth) {
        if (originalWidth <= scaledWidth) {
            return currentUrl;
        }
        String path = FilenameUtils.normalize((String)("resized/" + currentUrl));
        String dimensionInfo = "-" + scaledWidth + "px";
        int pos = path.lastIndexOf(46);
        path = pos != -1 ? path.substring(0, pos) + dimensionInfo + path.substring(pos) : path + dimensionInfo;
        return path;
    }

    private static String buildImageWrapperDivs(ImageMetadata imageMetadata, int width) {
        if (imageMetadata.getBorder() != ImageBorderEnum.THUMB && imageMetadata.getBorder() != ImageBorderEnum.FRAME) {
            if (imageMetadata.getHorizontalAlignment() == ImageHorizontalAlignmentEnum.LEFT) {
                return "<div class=\"floatleft\">{0}</div>";
            }
            if (imageMetadata.getHorizontalAlignment() == ImageHorizontalAlignmentEnum.RIGHT) {
                return "<div class=\"floatright\">{0}</div>";
            }
            if (imageMetadata.getHorizontalAlignment() == ImageHorizontalAlignmentEnum.CENTER) {
                return "<div class=\"center\">\n<div class=\"floatnone\">{0}</div>\n</div>";
            }
            if (imageMetadata.getHorizontalAlignment() == ImageHorizontalAlignmentEnum.NONE) {
                return "<div class=\"floatnone\">{0}</div>";
            }
            return "{0}";
        }
        String styleWidth = " style=\"width:" + (width + 2) + "px\"";
        if (imageMetadata.getHorizontalAlignment() == ImageHorizontalAlignmentEnum.CENTER) {
            return "<div class=\"center\">\n<div class=\"thumb tnone\">\n<div class=\"thumbinner\"" + styleWidth + ">{0}</div>\n</div>\n</div>";
        }
        if (imageMetadata.getHorizontalAlignment() == ImageHorizontalAlignmentEnum.LEFT) {
            return "<div class=\"thumb tleft\">\n<div class=\"thumbinner\"" + styleWidth + ">{0}</div>\n</div>";
        }
        return "<div class=\"thumb tright\">\n<div class=\"thumbinner\"" + styleWidth + ">{0}</div>\n</div>";
    }

    private static String buildLinkToFile(String url, Topic topic, String caption, boolean escapeHtml) {
        StringBuilder html = new StringBuilder();
        if (StringUtils.isBlank((String)caption)) {
            caption = topic.getPageName();
        }
        html.append("<a href=\"").append(url).append("\">");
        if (escapeHtml) {
            html.append(StringEscapeUtils.escapeHtml((String)caption));
        } else {
            html.append(caption);
        }
        html.append("</a>");
        return html.toString();
    }

    private static String buildUploadLink(String context, String virtualWiki, String topicName) throws DataAccessException {
        WikiLink uploadLink = LinkUtil.parseWikiLink(virtualWiki, "Special:Upload?topic=" + Utilities.encodeAndEscapeTopicName(topicName));
        return LinkUtil.buildInternalLinkHtml(context, virtualWiki, uploadLink, topicName, "edit", null, true);
    }

    private static int calculateImageIncrement(double dimension) {
        int increment = Environment.getIntValue("image-resize-increment");
        return (int)(Math.ceil(dimension / (double)increment) * (double)increment);
    }

    private static Dimension calculateIncrementalDimensions(WikiImage wikiImage, Dimension originalDimensions, Dimension scaledDimensions) throws IOException {
        int increment = Environment.getIntValue("image-resize-increment");
        int incrementalWidth = ImageUtil.calculateImageIncrement(scaledDimensions.getWidth());
        if (increment <= 0 || (double)incrementalWidth >= originalDimensions.getWidth()) {
            return originalDimensions;
        }
        int incrementalHeight = (int)Math.round((double)incrementalWidth / originalDimensions.getWidth() * originalDimensions.getHeight());
        String newUrl = ImageUtil.buildImagePath(wikiImage.getUrl(), (int)originalDimensions.getWidth(), incrementalWidth);
        File newImageFile = new File(Environment.getValue("file-dir-full-path"), newUrl);
        if (newImageFile.exists()) {
            return new Dimension(incrementalWidth, incrementalHeight);
        }
        File imageFile = new File(Environment.getValue("file-dir-full-path"), wikiImage.getUrl());
        BufferedImage bufferedImage = ImageProcessor.resizeImage(imageFile, incrementalWidth, incrementalHeight);
        newUrl = ImageUtil.buildImagePath(wikiImage.getUrl(), (int)originalDimensions.getWidth(), bufferedImage.getWidth());
        newImageFile = new File(Environment.getValue("file-dir-full-path"), newUrl);
        ImageProcessor.saveImage(bufferedImage, newImageFile);
        return new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    private static Dimension calculateScaledDimensions(Dimension originalDimensions, int maxWidth, int maxHeight) {
        int height;
        int width;
        if (maxWidth <= 0 && maxHeight <= 0) {
            return originalDimensions;
        }
        double heightScalingFactor = (double)maxHeight / originalDimensions.getHeight();
        double widthScalingFactor = (double)maxWidth / originalDimensions.getWidth();
        if (maxWidth <= 0) {
            width = (int)Math.round(heightScalingFactor * originalDimensions.getWidth());
            height = (int)Math.round(heightScalingFactor * originalDimensions.getHeight());
        } else if (maxHeight <= 0) {
            width = (int)Math.round(widthScalingFactor * originalDimensions.getWidth());
            height = (int)Math.round(widthScalingFactor * originalDimensions.getHeight());
        } else if (heightScalingFactor < widthScalingFactor) {
            width = (int)Math.round(heightScalingFactor * originalDimensions.getWidth());
            height = (int)Math.round(heightScalingFactor * originalDimensions.getHeight());
        } else {
            width = (int)Math.round(widthScalingFactor * originalDimensions.getWidth());
            height = (int)Math.round(widthScalingFactor * originalDimensions.getHeight());
        }
        return new Dimension(width, height);
    }

    public static String generateFileUrl(String virtualWiki, String filename, Date date) throws WikiException {
        String second;
        String minute;
        String hour;
        String day;
        if (StringUtils.isBlank((String)virtualWiki)) {
            throw new WikiException(new WikiMessage("common.exception.novirtualwiki"));
        }
        String url = filename;
        if (StringUtils.isBlank((String)url)) {
            throw new WikiException(new WikiMessage("upload.error.filename"));
        }
        GregorianCalendar cal = new GregorianCalendar();
        if (date != null) {
            cal.setTime(date);
        }
        if ((day = Integer.toString(cal.get(5))).length() == 1) {
            day = "0" + day;
        }
        if ((hour = Integer.toString(cal.get(11))).length() == 1) {
            hour = "0" + hour;
        }
        if ((minute = Integer.toString(cal.get(12))).length() == 1) {
            minute = "0" + minute;
        }
        if ((second = Integer.toString(cal.get(13))).length() == 1) {
            second = "0" + second;
        }
        String suffix = "-" + day + hour + minute + second;
        int pos = url.lastIndexOf(46);
        url = pos == -1 ? url + suffix : url.substring(0, pos) + suffix + url.substring(pos);
        String year = Integer.toString(cal.get(1));
        String month = Integer.toString(cal.get(2) + 1);
        String subdirectory = "/" + virtualWiki + "/" + year + "/" + month;
        File directory = new File(Environment.getValue("file-dir-full-path"), subdirectory);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new WikiException(new WikiMessage("upload.error.directorycreate", directory.getAbsolutePath()));
        }
        return subdirectory + "/" + url;
    }

    public static String generateFileTopicName(String virtualWiki, String filename) {
        String topicName = Namespace.namespace(6).getLabel(virtualWiki) + ":";
        topicName = topicName + Utilities.decodeAndEscapeTopicName(filename, true);
        return topicName;
    }

    private static WikiImage initializeWikiImage(WikiFile wikiFile, ImageMetadata imageMetadata) throws DataAccessException, IOException {
        if (wikiFile == null) {
            throw new IllegalArgumentException("wikiFile may not be null");
        }
        WikiImage wikiImage = new WikiImage(wikiFile);
        Dimension originalDimensions = ImageUtil.retrieveFromCache(wikiImage);
        if (originalDimensions == null) {
            File file = new File(Environment.getValue("file-dir-full-path"), wikiImage.getUrl());
            originalDimensions = ImageProcessor.retrieveImageDimensions(file);
            if (originalDimensions == null) {
                logger.info("Unable to determine dimensions for image: " + wikiImage.getUrl());
                return null;
            }
            ImageUtil.addToCache(wikiImage, originalDimensions);
        }
        if (!imageMetadata.getAllowEnlarge() && (double)imageMetadata.getMaxWidth() > originalDimensions.getWidth() && (double)imageMetadata.getMaxHeight() > originalDimensions.getHeight()) {
            imageMetadata.setMaxWidth((int)originalDimensions.getWidth());
            imageMetadata.setMaxHeight((int)originalDimensions.getHeight());
        }
        Dimension scaledDimensions = ImageUtil.calculateScaledDimensions(originalDimensions, imageMetadata.getMaxWidth(), imageMetadata.getMaxHeight());
        wikiImage.setWidth((int)scaledDimensions.getWidth());
        wikiImage.setHeight((int)scaledDimensions.getHeight());
        Dimension incrementalDimensions = ImageUtil.calculateIncrementalDimensions(wikiImage, originalDimensions, scaledDimensions);
        String url = ImageUtil.buildImagePath(wikiImage.getUrl(), (int)originalDimensions.getWidth(), (int)incrementalDimensions.getWidth());
        wikiImage.setUrl(url);
        return wikiImage;
    }

    public static boolean isFileTypeAllowed(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        int blacklistType = Environment.getIntValue("file-blacklist-type");
        if (blacklistType == 0) {
            return true;
        }
        if (blacklistType == 1) {
            return false;
        }
        if (StringUtils.isBlank((String)extension)) {
            return true;
        }
        extension = extension.toLowerCase();
        List list = WikiUtil.retrieveUploadFileList();
        if (blacklistType == 2) {
            return !list.contains(extension);
        }
        if (blacklistType == 3) {
            return list.contains(extension);
        }
        return false;
    }

    public static boolean isImage(File file) {
        try {
            return ImageProcessor.retrieveImageDimensions(file) != null;
        }
        catch (IOException x) {
            return false;
        }
    }

    private static Dimension retrieveFromCache(WikiImage wikiImage) throws DataAccessException {
        String key = wikiImage.getVirtualWiki() + "/" + wikiImage.getUrl();
        Element cachedDimensions = WikiCache.retrieveFromCache(CACHE_IMAGE_DIMENSIONS, key);
        return cachedDimensions != null ? (Dimension)cachedDimensions.getObjectValue() : null;
    }

    public static String sanitizeFilename(String filename) {
        if (StringUtils.isBlank((String)filename)) {
            return null;
        }
        filename = FilenameUtils.getName((String)filename);
        filename = StringUtils.replace((String)filename.trim(), (String)" ", (String)"_");
        return filename;
    }

    public static Topic writeImageTopic(String virtualWiki, String topicName, String contents, WikiUser user, boolean isImage, String ipAddress) throws DataAccessException, ParserException, WikiException {
        Topic topic = WikiBase.getDataHandler().lookupTopic(virtualWiki, topicName, false, null);
        int charactersChanged = 0;
        if (topic == null || !StringUtils.equals((String)virtualWiki, (String)topic.getVirtualWiki())) {
            topic = new Topic(virtualWiki, topicName);
            topic.setTopicContent(contents);
            charactersChanged = StringUtils.length((String)contents);
        }
        if (isImage) {
            topic.setTopicType(TopicType.IMAGE);
        } else {
            topic.setTopicType(TopicType.FILE);
        }
        TopicVersion topicVersion = new TopicVersion(user, ipAddress, contents, topic.getTopicContent(), charactersChanged);
        topicVersion.setEditType(9);
        ParserOutput parserOutput = ParserUtil.parserOutput(topic.getTopicContent(), virtualWiki, topicName);
        WikiBase.getDataHandler().writeTopic(topic, topicVersion, parserOutput.getCategories(), parserOutput.getLinks());
        return topic;
    }

    public static WikiFile writeWikiFile(Topic topic, WikiFileVersion wikiFileVersion, WikiUser user, String ipAddress, String filename, String url, String contentType, long fileSize) throws DataAccessException, WikiException {
        wikiFileVersion.setAuthorDisplay(ipAddress);
        Integer authorId = null;
        if (user != null && user.getUserId() > 0) {
            authorId = user.getUserId();
        }
        wikiFileVersion.setAuthorId(authorId);
        WikiFile wikiFile = WikiBase.getDataHandler().lookupWikiFile(topic.getVirtualWiki(), topic.getName());
        if (wikiFile == null || !StringUtils.equals((String)wikiFile.getVirtualWiki(), (String)topic.getVirtualWiki())) {
            wikiFile = new WikiFile();
            wikiFile.setVirtualWiki(topic.getVirtualWiki());
        }
        wikiFile.setFileName(filename);
        wikiFile.setUrl(url);
        wikiFileVersion.setUrl(url);
        wikiFileVersion.setMimeType(contentType);
        wikiFile.setMimeType(contentType);
        wikiFileVersion.setFileSize(fileSize);
        wikiFile.setFileSize(fileSize);
        wikiFile.setTopicId(topic.getTopicId());
        WikiBase.getDataHandler().writeFile(wikiFile, wikiFileVersion);
        return wikiFile;
    }
}

