/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.struts.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.portals.bridges.struts.config.AbstractConfigComponent;

public class RenderContextAttributes
extends AbstractConfigComponent {
    private String name = this.getClass().getName();
    private Attribute[] namedAttributes;
    private Attribute[] prefixAttributes;
    private ArrayList namedAttributesList = new ArrayList();
    private ArrayList prefixAttributesList = new ArrayList();

    private Attribute[] createArray(List attributes) {
        Attribute[] array = null;
        if (attributes != null && attributes.size() > 0) {
            array = new Attribute[attributes.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Attribute)attributes.get(i);
            }
        }
        return array;
    }

    public void addAttribute(Attribute attribute) {
        this.checkLoaded();
        if (attribute.isPrefixAttr()) {
            this.prefixAttributesList.add(attribute);
        } else {
            this.namedAttributesList.add(attribute);
        }
    }

    public void setName(String name) {
        this.checkLoaded();
        this.name = name;
    }

    public void configure(Digester digester) {
        digester.addRule("config/render-context", (Rule)new AbstractConfigComponent.SetParentRule(this));
        digester.addSetProperties("config/render-context");
        digester.addObjectCreate("config/render-context/attribute", Attribute.class);
        digester.addSetProperties("config/render-context/attribute");
        digester.addSetNext("config/render-context/attribute", "addAttribute");
        digester.addCallMethod("config/render-context", "afterLoad");
    }

    public void afterLoad() {
        super.afterLoad();
        this.namedAttributes = this.createArray(this.namedAttributesList);
        this.prefixAttributes = this.createArray(this.prefixAttributesList);
        this.namedAttributesList = null;
        this.prefixAttributesList = null;
    }

    public void saveAttributes(HttpServletRequest request) {
        ArrayList<AttributeValue> keepAttributes = new ArrayList<AttributeValue>();
        ArrayList<AttributeValue> tempAttributes = new ArrayList<AttributeValue>();
        ArrayList<String> savedNames = new ArrayList<String>();
        if (this.namedAttributes != null) {
            for (int i = 0; i < this.namedAttributes.length; ++i) {
                Object value = request.getAttribute(this.namedAttributes[i].getValue());
                if (value == null) continue;
                AttributeValue attributeValue = new AttributeValue(this.namedAttributes[i].getValue(), value);
                savedNames.add(attributeValue.getName());
                if (this.namedAttributes[i].isKeep()) {
                    keepAttributes.add(attributeValue);
                    continue;
                }
                tempAttributes.add(attributeValue);
            }
        }
        if (this.prefixAttributes != null) {
            Enumeration names = request.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                for (int i = 0; i < this.prefixAttributes.length; ++i) {
                    if (savedNames.contains(name) || !name.startsWith(this.prefixAttributes[i].getValue())) continue;
                    AttributeValue attributeValue = new AttributeValue(name, request.getAttribute(name));
                    savedNames.add(name);
                    if (this.prefixAttributes[i].isKeep()) {
                        keepAttributes.add(attributeValue);
                        continue;
                    }
                    tempAttributes.add(attributeValue);
                }
            }
        }
        if (keepAttributes.size() > 0) {
            if (tempAttributes.size() > 0) {
                keepAttributes.add(null);
                keepAttributes.addAll(tempAttributes);
            }
            request.getSession().setAttribute(this.name, keepAttributes);
        } else if (tempAttributes.size() > 0) {
            tempAttributes.add(0, null);
            request.getSession().setAttribute(this.name, tempAttributes);
        }
    }

    public void clearAttributes(HttpSession session) {
        session.removeAttribute(this.name);
    }

    public void restoreAttributes(HttpServletRequest request) {
        ArrayList attributes = (ArrayList)request.getSession().getAttribute(this.name);
        if (attributes != null) {
            int size = attributes.size();
            for (int i = size - 1; i > -1; --i) {
                AttributeValue attributeValue = (AttributeValue)attributes.get(i);
                if (attributeValue == null) {
                    if (i == 0) {
                        request.getSession().removeAttribute(this.name);
                        continue;
                    }
                    while (size > i) {
                        attributes.remove(--size);
                    }
                    continue;
                }
                request.setAttribute(attributeValue.getName(), attributeValue.getValue());
            }
        }
    }

    public static class Attribute {
        private String value;
        private boolean prefix;
        private boolean keep;

        public boolean isKeep() {
            return this.keep;
        }

        public void setKeep(boolean keep) {
            this.keep = keep;
        }

        public boolean isPrefixAttr() {
            return this.prefix;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String value) {
            this.value = value;
            this.prefix = false;
        }

        public void setPrefix(String value) {
            this.value = value;
            this.prefix = true;
        }
    }

    private static class AttributeValue
    implements Serializable {
        private String name;
        private Object value;

        public AttributeValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

