/*
 * Decompiled with CFR 0.152.
 */
package lombok.installer.eclipse;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import lombok.installer.CorruptedIdeLocationException;
import lombok.installer.IdeFinder;
import lombok.installer.IdeLocation;
import lombok.installer.eclipse.EclipseLocationProvider;
import lombok.installer.eclipse.JbdsLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbdsLocationProvider
extends EclipseLocationProvider {
    @Override
    protected List<String> getEclipseExecutableNames() {
        return Arrays.asList("jbdevstudio.app", "jbdevstudio.exe", "jbdevstudioc.exe", "jbdevstudio");
    }

    @Override
    protected String getIniName() {
        return "jbdevstudio.ini";
    }

    @Override
    protected IdeLocation makeLocation(String name, File ini) throws CorruptedIdeLocationException {
        return new JbdsLocation(name, ini);
    }

    @Override
    protected String getMacAppName() {
        return "jbdevstudio.app";
    }

    @Override
    protected String getUnixAppName() {
        return "jbdevstudio";
    }

    @Override
    public Pattern getLocationSelectors(IdeFinder.OS os) {
        switch (os) {
            case MAC_OS_X: {
                return Pattern.compile("^(jbdevstudio|jbdevstudio\\.ini|jbdevstudio\\.app)$", 2);
            }
            case WINDOWS: {
                return Pattern.compile("^(jbdevstudioc?\\.exe|jbdevstudio\\.ini)$", 2);
            }
        }
        return Pattern.compile("^(jbdevstudio|jbdevstudio\\.ini)$", 2);
    }
}

