/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util;

import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.layoutconfiguration.util.PortletRenderer;
import com.liferay.portal.layoutconfiguration.util.RuntimePage;
import com.liferay.portal.layoutconfiguration.util.velocity.CustomizationSettingsProcessor;
import com.liferay.portal.layoutconfiguration.util.velocity.TemplateProcessor;
import com.liferay.portal.layoutconfiguration.util.xml.ActionURLLogic;
import com.liferay.portal.layoutconfiguration.util.xml.PortletLogic;
import com.liferay.portal.layoutconfiguration.util.xml.RenderURLLogic;
import com.liferay.portal.layoutconfiguration.util.xml.RuntimeLogic;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.servlet.ThreadLocalFacadeServletRequestWrapperUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.taglib.util.DummyVelocityTaglib;
import com.liferay.taglib.util.VelocityTaglibImpl;
import java.io.Closeable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.time.StopWatch;

@DoPrivileged
public class RuntimePageImpl
implements RuntimePage {
    private static Log _log = LogFactoryUtil.getLog(RuntimePageImpl.class);
    private int _waitTime = Integer.MAX_VALUE;

    public StringBundler getProcessedTemplate(PageContext pageContext, String portletId, TemplateResource templateResource) throws Exception {
        return this.doDispatch(pageContext, portletId, templateResource, true);
    }

    public void processCustomizationSettings(PageContext pageContext, TemplateResource templateResource) throws Exception {
        this.doDispatch(pageContext, null, templateResource, false);
    }

    public void processTemplate(PageContext pageContext, String portletId, TemplateResource templateResource) throws Exception {
        StringBundler sb = this.doDispatch(pageContext, portletId, templateResource, true);
        sb.writeTo((Writer)pageContext.getOut());
    }

    public void processTemplate(PageContext pageContext, TemplateResource templateResource) throws Exception {
        this.processTemplate(pageContext, null, templateResource);
    }

    public String processXML(HttpServletRequest request, HttpServletResponse response, String content) throws Exception {
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        if (portletResponse != null && !(portletResponse instanceof RenderResponse)) {
            throw new IllegalArgumentException("processXML can only be invoked in the render phase");
        }
        PortletLogic portletLogic = new PortletLogic(request, response);
        content = this.processXML(request, content, portletLogic);
        if (portletResponse == null) {
            return content;
        }
        RenderResponse renderResponse = (RenderResponse)portletResponse;
        ActionURLLogic actionURLLogic = new ActionURLLogic(renderResponse);
        RenderURLLogic renderURLLogic = new RenderURLLogic(renderResponse);
        content = this.processXML(request, content, actionURLLogic);
        content = this.processXML(request, content, renderURLLogic);
        return content;
    }

    public String processXML(HttpServletRequest request, String content, RuntimeLogic runtimeLogic) throws Exception {
        if (Validator.isNull((String)content)) {
            return "";
        }
        int index = content.indexOf(runtimeLogic.getOpenTag());
        if (index == -1) {
            return content;
        }
        Portlet renderPortlet = (Portlet)request.getAttribute("RENDER_PORTLET");
        Boolean renderPortletResource = (Boolean)request.getAttribute("RENDER_PORTLET_RESOURCE");
        String outerPortletId = (String)request.getAttribute("OUTER_PORTLET_ID");
        if (outerPortletId == null) {
            request.setAttribute("OUTER_PORTLET_ID", (Object)renderPortlet.getPortletId());
        }
        try {
            request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
            StringBundler sb = new StringBundler();
            int x = 0;
            int y = index;
            while (y != -1) {
                sb.append(content.substring(x, y));
                int close1 = content.indexOf(runtimeLogic.getClose1Tag(), y);
                int close2 = content.indexOf(runtimeLogic.getClose2Tag(), y);
                x = close2 == -1 || close1 != -1 && close1 < close2 ? close1 + runtimeLogic.getClose1Tag().length() : close2 + runtimeLogic.getClose2Tag().length();
                String runtimePortletTag = content.substring(y, x);
                if (renderPortlet != null && runtimePortletTag.contains(renderPortlet.getPortletId())) {
                    return "";
                }
                sb.append(runtimeLogic.processXML(runtimePortletTag));
                y = content.indexOf(runtimeLogic.getOpenTag(), x);
            }
            if (y == -1) {
                sb.append(content.substring(x));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (outerPortletId == null) {
                request.removeAttribute("OUTER_PORTLET_ID");
            }
            request.setAttribute("RENDER_PORTLET", (Object)renderPortlet);
            if (renderPortletResource == null) {
                request.removeAttribute("RENDER_PORTLET_RESOURCE");
            } else {
                request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)renderPortletResource);
            }
        }
    }

    protected StringBundler doDispatch(PageContext pageContext, String portletId, TemplateResource templateResource, boolean processTemplate) throws Exception {
        String pluginServletContextName;
        ServletContext pluginServletContext;
        ClassLoader pluginClassLoader = null;
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(templateResource.getTemplateId());
        if (layoutTemplate != null && (pluginServletContext = ServletContextPool.get((String)(pluginServletContextName = GetterUtil.getString((String)layoutTemplate.getServletContextName())))) != null) {
            pluginClassLoader = (ClassLoader)pluginServletContext.getAttribute("PLUGIN_CLASS_LOADER");
        }
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                ClassLoaderUtil.setContextClassLoader(pluginClassLoader);
            }
            if (processTemplate) {
                StringBundler stringBundler = this.doProcessTemplate(pageContext, portletId, templateResource, false);
                return stringBundler;
            }
            this.doProcessCustomizationSettings(pageContext, templateResource, false);
            return null;
        }
        finally {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected void doProcessCustomizationSettings(PageContext pageContext, TemplateResource templateResource, boolean restricted) throws Exception {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        CustomizationSettingsProcessor processor = new CustomizationSettingsProcessor(pageContext);
        Template template = TemplateManagerUtil.getTemplate((String)"vm", (TemplateResource)templateResource, (boolean)restricted);
        template.put("processor", (Object)processor);
        template.prepare(request);
        DummyVelocityTaglib velocityTaglib = new DummyVelocityTaglib();
        template.put("taglibLiferay", (Object)velocityTaglib);
        template.put("theme", (Object)velocityTaglib);
        try {
            template.processTemplate((Writer)pageContext.getOut());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw e2;
        }
    }

    protected StringBundler doProcessTemplate(PageContext pageContext, String portletId, TemplateResource templateResource, boolean restricted) throws Exception {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        TemplateProcessor processor = new TemplateProcessor(request, response, portletId);
        Template template = TemplateManagerUtil.getTemplate((String)"vm", (TemplateResource)templateResource, (boolean)restricted);
        template.put("processor", (Object)processor);
        template.prepare(request);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        VelocityTaglibImpl velocityTaglib = new VelocityTaglibImpl(pageContext.getServletContext(), request, (HttpServletResponse)new PipingServletResponse(response, (Writer)unsyncStringWriter), pageContext, template);
        template.put("taglibLiferay", (Object)velocityTaglib);
        template.put("theme", (Object)velocityTaglib);
        try {
            template.processTemplate((Writer)unsyncStringWriter);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw e2;
        }
        boolean portletParallelRender = GetterUtil.getBoolean((Object)request.getAttribute("PORTLET_PARALLEL_RENDER"));
        ReentrantLock lock = null;
        HashMap<String, StringBundler> contentsMap = new HashMap<String, StringBundler>();
        Map<Integer, List<PortletRenderer>> portletRenderersMap = processor.getPortletRenderers();
        for (Map.Entry<Integer, List<PortletRenderer>> entry : portletRenderersMap.entrySet()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing portlets with render weight " + entry.getKey()));
            }
            List<PortletRenderer> portletRenderers = entry.getValue();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (portletParallelRender && portletRenderers.size() > 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Start parallel rendering");
                }
                if (lock == null) {
                    lock = new ReentrantLock();
                }
                request.setAttribute("PARALLEL_RENDERING_MERGE_LOCK", (Object)lock);
                ObjectValuePair<HttpServletRequest, Closeable> objectValuePair = ThreadLocalFacadeServletRequestWrapperUtil.inject(request);
                try {
                    this.parallelyRenderPortlets((HttpServletRequest)objectValuePair.getKey(), response, processor, contentsMap, portletRenderers);
                }
                finally {
                    Closeable closeable = (Closeable)objectValuePair.getValue();
                    closeable.close();
                }
                request.removeAttribute("PARALLEL_RENDERING_MERGE_LOCK");
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Finished parallel rendering in " + stopWatch.getTime() + " ms"));
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Start serial rendering");
            }
            for (PortletRenderer portletRenderer : portletRenderers) {
                Portlet portlet = portletRenderer.getPortlet();
                contentsMap.put(portlet.getPortletId(), portletRenderer.render(request, response));
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Serially rendered portlet " + portlet.getPortletId() + " in " + stopWatch.getTime() + " ms"));
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Finished serial rendering in " + stopWatch.getTime() + " ms"));
        }
        if (portletParallelRender && this._waitTime == Integer.MAX_VALUE) {
            this._waitTime = PropsValues.LAYOUT_PARALLEL_RENDER_TIMEOUT;
        }
        StringBundler sb = StringUtil.replaceWithStringBundler((String)unsyncStringWriter.toString(), (String)"[$TEMPLATE_PORTLET_", (String)"$]", contentsMap);
        return sb;
    }

    protected LayoutTemplate getLayoutTemplate(String velocityTemplateId) {
        String separator = "_CUSTOM_";
        boolean standard = false;
        if (velocityTemplateId.contains("_STANDARD_")) {
            separator = "_STANDARD_";
            standard = true;
        }
        String layoutTemplateId = null;
        String themeId = null;
        int pos = velocityTemplateId.indexOf(separator);
        if (pos != -1) {
            layoutTemplateId = velocityTemplateId.substring(pos + separator.length());
            themeId = velocityTemplateId.substring(0, pos);
        }
        if ((pos = layoutTemplateId.indexOf("_INSTANCE_")) != -1) {
            layoutTemplateId = layoutTemplateId.substring(pos + "_INSTANCE_".length() + 1);
            pos = layoutTemplateId.indexOf("_");
            layoutTemplateId = layoutTemplateId.substring(pos + 1);
        }
        return LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateId, (boolean)standard, themeId);
    }

    protected void parallelyRenderPortlets(HttpServletRequest request, HttpServletResponse response, TemplateProcessor processor, Map<String, StringBundler> contentsMap, List<PortletRenderer> portletRenderers) throws Exception {
        ThreadPoolExecutor executorService = PortalExecutorManagerUtil.getPortalExecutor((String)RuntimePageImpl.class.getName());
        HashMap<Future<StringBundler>, PortletRenderer> futures = new HashMap<Future<StringBundler>, PortletRenderer>(portletRenderers.size());
        for (PortletRenderer portletRenderer : portletRenderers) {
            if (_log.isDebugEnabled()) {
                Portlet portlet = portletRenderer.getPortlet();
                _log.debug((Object)("Submit portlet " + portlet.getPortletId() + " for parallel rendering"));
            }
            Callable<StringBundler> renderCallable = portletRenderer.getCallable(request, response);
            Future<StringBundler> future = null;
            try {
                future = executorService.submit(renderCallable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                future = new FutureTask<StringBundler>(renderCallable);
                future.cancel(true);
            }
            futures.put(future, portletRenderer);
        }
        long waitTime = this._waitTime;
        for (Map.Entry entry : futures.entrySet()) {
            Future future = (Future)entry.getKey();
            PortletRenderer portletRenderer = (PortletRenderer)entry.getValue();
            Portlet portlet = portletRenderer.getPortlet();
            if (future.isCancelled()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Reject portlet " + portlet.getPortletId() + " for parallel rendering"));
                }
            } else if (waitTime > 0L || future.isDone()) {
                try {
                    long startTime = System.currentTimeMillis();
                    StringBundler sb = (StringBundler)future.get(waitTime, TimeUnit.MILLISECONDS);
                    long duration = System.currentTimeMillis() - startTime;
                    waitTime -= duration;
                    contentsMap.put(portlet.getPortletId(), sb);
                    portletRenderer.finishParallelRender();
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Parallely rendered portlet " + portlet.getPortletId() + " in " + duration + " ms"));
                    continue;
                }
                catch (ExecutionException ee) {
                    throw ee;
                }
                catch (InterruptedException interruptedException) {
                    waitTime = -1L;
                }
                catch (TimeoutException timeoutException) {
                    waitTime = -1L;
                }
                catch (CancellationException ce) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Asynchronized cancellation detected that should only be caused by a concurrent shutdown of the thread pool", (Throwable)ce);
                    }
                    return;
                }
                future.cancel(true);
            }
            StringBundler sb = null;
            if (processor.isPortletAjaxRender() && portlet.isAjaxable()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Fall back to ajax rendering of portlet " + portlet.getPortletId()));
                }
                sb = portletRenderer.renderAjax(request, response);
            } else {
                if (_log.isDebugEnabled()) {
                    if (processor.isPortletAjaxRender()) {
                        _log.debug((Object)("Fall back to an error message for portlet " + portlet.getPortletId() + " since it is not ajaxable"));
                    } else {
                        _log.debug((Object)("Fall back to an error message for portlet " + portlet.getPortletId() + " since ajax rendering is disabled"));
                    }
                }
                sb = portletRenderer.renderError(request, response);
            }
            contentsMap.put(portlet.getPortletId(), sb);
            portletRenderer.finishParallelRender();
        }
    }
}

